% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demo_janeausten.R
\name{demo_jane_austen}
\alias{demo_jane_austen}
\alias{run_janeausten_app}
\alias{create_janeausten_app}
\title{Demo app: Jane Austen's novels}
\usage{
run_janeausten_app(...)

create_janeausten_app()
}
\arguments{
\item{...}{Arguments passed to \code{explore()}}
}
\value{
\code{run_janeausten_app()} launches a Shiny app. \code{create_janeausten_app()} returns
  a corporaexplorerobject.
}
\description{
\code{run_janeausten_app()} is a convenience function to directly
  run the demo app without first creating
  a corporaexplorerobject.
  Equals \code{explore(create_janeausten_app())}.
  Interrupt R to stop the
  application (usually by pressing Ctrl+C or Esc).
}
\details{
The demo app's data are Jane Austen's six novels, retrieved
  through the "janeaustenr" package
  (\url{https://github.com/juliasilge/janeaustenr}) --
  which must be installed for these functions to work --
  and converted to a corporaexplorerobject as shown at
  \url{https://kgjerde.github.io/corporaexplorer/articles/jane_austen.html}.
}
\examples{
## Create corporaexplorerobject for demo app:
jane_austen <- create_janeausten_app()

if(interactive()){

## Run the corporaexplorerobject:
explore(jane_austen)

## Or create and run the demo app in one step:

run_janeausten_app()

}
}
