% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_correlation_matrix.R
\name{save_correlation_matrix}
\alias{save_correlation_matrix}
\title{Creates and save to file a fully formatted correlation matrix, using \code{correlation_matrix} and \code{Hmisc::rcorr} in the backend}
\usage{
save_correlation_matrix(df, filename, ...)
}
\arguments{
\item{df}{dataframe; passed to \code{correlation_matrix}}

\item{filename}{either a character string naming a file or a connection open for writing. "" indicates output to the console; passed to \code{write.csv}}

\item{...}{any other arguments passed to \code{correlation_matrix}}
}
\value{
'csv' file.  No value is returned.
}
\description{
Creates and save to file a fully formatted correlation matrix, using \code{correlation_matrix} and \code{Hmisc::rcorr} in the backend
}
\examples{
\donttest{
save_correlation_matrix(df = iris,
                        filename = 'iris-correlation-matrix.csv')

save_correlation_matrix(df = mtcars,
                        filename = 'mtcars-correlation-matrix.csv',
                        digits = 3,
                        use = 'lower')
                        }
}
