% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosimmr_load.R
\name{cosimmr_load}
\alias{cosimmr_load}
\title{Function to load in cosimmr data and check for errors}
\usage{
cosimmr_load(
  formula,
  source_names,
  source_means,
  source_sds,
  correction_means = NULL,
  correction_sds = NULL,
  concentration_means = NULL,
  scale_x = TRUE
)
}
\arguments{
\item{formula}{Formula giving in form y ~ x where y is a vector or matrix
of mixture values and x is a vector or matrix of covariates}

\item{source_names}{The names of the sources given as a character string}

\item{source_means}{The means of the source values, given as a matrix where
the number of rows is the number of sources and the number of columns is the
number of tracers}

\item{source_sds}{The standard deviations of the source values, given as a
matrix where the number of rows is the number of sources and the number of
columns is the number of tracers}

\item{correction_means}{The means of the correction values, given as a
matrix where the number of rows is the number of sources and the number of
columns is the number of tracers. If not provided these are set to 0.}

\item{correction_sds}{The standard deviations of the correction values,
given as a matrix where the number of rows is the number of sources and the
number of columns is the number of tracers. If not provided these are set to
0.}

\item{concentration_means}{The means of the concentration values, given as a
matrix where the number of rows is the number of sources and the number of
columns is the number of tracers. These should be between 0 and 1. If not
provided these are all set to 1.}

\item{scale_x}{Whether or not you wish to scale the x values provided, or run 
the model using the original x values. Defaults to TRUE.}
}
\value{
An object of class \code{cosimmr_input} with the following elements:
\item{mixtures }{The mixture data} \item{source_names }{Source means}
\item{sources_sds }{Source standard deviations} \item{correction_means
}{Correction means} \item{correction_sds }{Correction standard deviations}
\item{concentration_means }{Concentration dependence means} \item{n_obs
}{The number of observations} \item{n_tracers }{The number of
tracers/isotopes} \item{n_sources }{The number of sources} \item{n_groups
}{The number of groups}
}
\description{
This function takes in the mixture data, food source means and standard
deviations, and (optionally) correction factor means and standard
deviations, and concentration proportions. It performs some (non-exhaustive)
checking of the data to make sure it will run through simmr. It outputs an
object of class \code{cosimmr_input}.
}
\details{
For standard stable isotope mixture modelling, the mixture matrix will
contain a row for each individual and a column for each isotopic value.
\code{cosimmr} will allow for any number of isotopes and any number of
observations, within computational limits. The source means/sds should be
provided for each food source on each isotope. The correction means (usually
trophic enrichment factors) can be set as zero if required, and should be of
the same shape as the source values. The concentration dependence means
should be estimated values of the proportion of each element in the food
source in question and should be given in proportion format between 0 and 1.
At present there is no means to include concentration standard deviations.
}
\examples{
\donttest{

# A simple example with 10 observations, 2 tracers and 4 sources
data(geese_data_day1)
simmr_1 <- with(
  geese_data_day1,
  cosimmr_load(
    formula = mixtures ~ 1,
    source_names = source_names,
    source_means = source_means,
    source_sds = source_sds,
    correction_means = correction_means,
    correction_sds = correction_sds,
    concentration_means = concentration_means,
    scale_x = TRUE
  )
)



print(simmr_1)
}
}
\seealso{
See \code{\link{cosimmr_ffvb}} for complete examples.
}
\author{
Emma Govan <emmagovan@gmail.com>, Andrew Parnell
}
