% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.R
\name{metric}
\alias{metric}
\title{The function \code{metric} provides a contingency table for the predicted class and the true class for binary classes.}
\usage{
metric(true, est)
}
\arguments{
\item{true}{binary true class.}

\item{est}{binary predicted class.}
}
\value{
a contingency table for the predicted results of binary class responses.
}
\description{
The function \code{metric} provides a contingency table for the predicted class and the true class for binary classes.
}
\examples{
\donttest{
set.seed(20250101)
tr = data_generation(n = 200, p = 20, SNR = 9, response = "continuous")
tr_x = tr$x
tr_y = tr$y

te = data_generation(n = 1000, p = 20, SNR = 9, response = "continuous")
te_x = te$x
te_y = te$y

# Fit the model
fit = cossonet(tr_x, tr_y, family = 'gaussian', gamma = 0.95, kernel = "spline", scale = TRUE,
      lambda0 = exp(seq(log(2^{-4}), log(2^{0}), length.out = 20)),
      lambda_theta = exp(seq(log(2^{-8}), log(2^{-6}), length.out = 20))
      )

# Predict new dataset
pred = cossonet.predict(fit, te_x)

# Calculate the contingency table for binary class
true_var = c(rep(1, 4), rep(0, 20-4))
est_var = ifelse(fit$theta_step$theta.new > 0, 1, 0)
metric(true_var, est_var)
}

}
