% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STAR_frequentist.R
\name{predict.lmstar}
\alias{predict.lmstar}
\title{Predict method for response in STAR linear model}
\usage{
\method{predict}{lmstar}(object, newdata = NULL, interval = FALSE, level = 0.95, N = 1000, ...)
}
\arguments{
\item{object}{Object of class "lmstar" as output by \code{\link{lm_star}}}

\item{newdata}{An optional matrix/data frame  in which to look for variables with which to predict.
If omitted, the fitted values are used.}

\item{interval}{logical; whether or not to include prediction intervals (default FALSE)}

\item{level}{Level for prediction intervals}

\item{N}{number of Monte Carlo samples from the posterior predictive distribution
used to approximate intervals; default is 1000}

\item{...}{Ignored}
}
\value{
Either a a vector of predictions (if interval=FALSE) or a matrix of predictions and
bounds with column names fit, lwr, and upr
}
\description{
Outputs predicted values based on an lmstar fit and optionally prediction intervals based
on the the (plug-in) predictive distribution for the STAR linear model
}
\details{
If interval=TRUE, then \code{predict.lmstar} uses a Monte Carlo approach to estimating the (plug-in)
predictive distribution for the STAR linear model. The algorithm iteratively samples
(i) the latent data given the observed data, (ii) the latent predictive data given the latent data from (i),
and (iii) (inverse) transforms and rounds the latent predictive data to obtain a
draw from the integer-valued predictive distribution.

The appropriate quantiles of these Monte Carlo draws are computed and reported as the prediction interval.
}
\note{
The ``plug-in" predictive distribution is a crude approximation. Better
approaches are available using the Bayesian models, e.g. \code{\link{blm_star}}, which provide samples
from the posterior predictive distribution.

For highly skewed responses, prediction intervals especially at lower levels may
not include the predicted value itself, since the mean is often much larger than the median.
}
\examples{
# Simulate data with count-valued response y:
x = seq(0, 1, length.out = 100)
y = rpois(n = length(x), lambda = exp(1.5 + 5*(x -.5)^2))

# Estimate model--assume a quadratic effect (better for illustration purposes)
fit = lm_star(y~x+I(x^2), transformation = 'sqrt')

#Compute the predictive draws for the test points (same as observed points here)
#Also compute intervals using plug-in predictive distribution
y_pred = predict(fit, interval=TRUE)

# Plot the results
plot(x, y, ylim = range(y, y_pred), main = 'STAR: Predictions and 95\% PI')
lines(x,y_pred[,"fit"], col='black', type='s', lwd=4)
lines(x, y_pred[,"lwr"], col='darkgray', type='s', lwd=4)
lines(x, y_pred[,"upr"], col='darkgray', type='s', lwd=4)

}
