% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitlist.R
\name{summary_fitlist}
\alias{summary_fitlist}
\title{Summary of estimates}
\usage{
summary_fitlist(fitlist)
}
\arguments{
\item{fitlist}{a list of fits, as created by \code{\link{fit_counts}}.}
}
\value{
Data frame with summarised results of all distribution models.
}
\description{
Counts are fitted to model(s) using the count name as the explanatory variable.
Estimates are presented in the table below along with the BIC values of their models.
Estimated coefficients of models (\code{lambda} for all distributions, \code{theta} for NB and ZINB, 
\code{r} for ZIP and ZINB).
}
\examples{
df <- data.frame(poisson = rpois(25, 0.3), binomial = rbinom(25, 1, 0.8))
fc <- fit_counts(df, model = "all") 
summary_fitlist(fc) 
}
\seealso{
\code{\link{fit_counts}}
}
