% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countryname.R
\name{countryname}
\alias{countryname}
\title{Convert country names in any language to another name or code}
\usage{
countryname(
  sourcevar,
  destination = "country.name.en",
  nomatch = NA,
  warn = TRUE
)
}
\arguments{
\item{sourcevar}{Vector which contains the codes or country names to be
converted (character or factor)}

\item{destination}{Coding scheme of destination (string such as "iso3c"
enclosed in quotes ""): type \code{?codelist} for a list of
available codes.}

\item{nomatch}{When countrycode fails to find a match for the code of
origin, it fills-in the destination vector with \code{nomatch}. The default
behavior is to fill non-matching codes with \code{NA}. If \code{nomatch = NULL},
countrycode tries to use the origin vector to fill-in missing values in the
destination vector. \code{nomatch} must be either \code{NULL}, of length 1, or of the same
length as \code{sourcevar}.}

\item{warn}{Prints unique elements from sourcevar for which no match was found}
}
\description{
Converts long country names in any language to one of many different country
code schemes or country names. \code{countryname} does 2 passes on the data.
First, it tries to detect variations of country names in many languages
extracted from the Unicode Common Locale Data Repository. Second, it applies
\code{countrycode}'s English regexes to try to match the remaining cases. Because
it does two passes, \code{countryname} can sometimes produce ambiguous results,
e.g., Saint Martin vs. Saint Martin (French Part). Users who need a "safer"
option can use: \code{countrycode(x, "country.name", "country.name")} Note that
the function works with non-ASCII characters. Please see the Github page for
examples.
}
\examples{
\dontrun{
x <- c('Afaganisitani', 'Barbadas', 'Sverige', 'UK')
countryname(x)
countryname(x, destination = 'iso3c')
}

}
