% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covCSE.r
\name{covCSE}
\alias{covCSE}
\title{Empirical Bayes core shrinkage covariance estimator}
\usage{
covCSE(data, n = NULL, p1 = NULL, p2 = NULL, tol = 1e-08)
}
\arguments{
\item{data}{either a numeric n*p1*p2 array consisting of n data matrices 
each of dimension p1*p2, or a p1*p2 covariance matrix of data of this type.
If the latter, the values of n, p1 and p2 must be specified.}

\item{n}{the sample size.}

\item{p1}{the row dimension of the data matrices.}

\item{p2}{the column dimension of the data matrices.}

\item{tol}{the convergence tolerance of the iterative algorithm.}
}
\value{
a covariance matrix of the same dimension as \code{S}. 
The attribute \code{w} of \code{S} gives the shrinkage weight on the 
Kronecker covariance of \code{S}.
}
\description{
Estimate a covariance matrix by adaptively shrinking the core.
}
\examples{
p1<-4 ; p2<-3 ; n<-20

# create a matrix Y with separable covariance
Sig1<-rWishart(1,p1,diag(p1))[,,1] 
Sig2<-rWishart(1,p2,diag(p2))[,,1] 

Y<-array(rnorm(n*p1*p2),dim=c(n,p1,p2))  
Y<-aperm( apply(Y,c(1,3),function(y){ msqrt(Sig1)\%*\%y } ),c(2,1,3)) 
Y<-aperm( apply(Y,c(1,2),function(y){ msqrt(Sig2)\%*\%y } ),c(2,3,1)) 

# covariance 
S<-mcov(Y) 
covCSE(S,n,p1,p2)  

# now an unstructured covariance
S<-rWishart(1,p1*p2,diag(p1*p2))[,,1] 
covCSE(S,n,p1,p2) 

}
\author{
Peter Hoff
}
