% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Calculated_Properties_Drug}
\alias{Calculated_Properties_Drug}
\title{Drug Calculated Properties}
\format{
a tibble with 3 variables:
\describe{
  \item{kind}{Name of the property}
  \item{value}{Predicted physicochemical properties; obtained by the use of
  prediction software such as ALGOPS and ChemAxon}
  \item{source}{Name of the software used to calculate this property,
  either ChemAxon or ALOGPS}
  \item{parent_key}{drugbank id}
}
}
\source{
\href{https://docs.drugbankplus.com/xml/}{Drugbank Documentation}
}
\usage{
Calculated_Properties_Drug
}
\description{
Drug properties that have been predicted by
ChemAxon or
\href{http://www.vcclab.org/lab/alogps/}{ALOGPS} based on the imputed
chemical structure. Associated links below will redirect to descriptions of
the specific term.
}
\details{
Each drug may have one or more calculated property.

The following calculated properties are provided:
\tabular{ll}{
\strong{Property} \tab \strong{Description} \cr
logP \tab The predicted partition coefficient (LogP) based on the ratio of
solubility of the molecule in 1-octanol compared to water; predicted by
\href{http://www.vcclab.org/lab/alogps/}{ALOGPS} \cr
logS \tab The predicted solubility (LogS) of the molecule;
predicted by \href{http://www.vcclab.org/lab/alogps/}{ALOGPS}. \cr
IUPAC Name \tab The predicted International Union of Pure and Applied
Chemistry (IUPAC) nomenclature for the structure; predicted by ChemAxon \cr
Traditional IUPAC Name	\tab The non-systematic (or common) name for the
molecule, which is not recognized by any formal nomenclature system;
imported from ChemAxon. \cr
Molecular Weight	 \tab The predicted ratio of the average mass of one
molecule of an element or compound to one twelfth of the mass of an atom of carbon-12; calculated by ChemAxon.\cr
Monoisotopic Weight \tab The predicted mass of the most abundant isotope of
the drug; calculated by ChemAxon. \cr
SMILES \tab The simplified molecular-input line-entry system (SMILES) is
a line notation used for describing the structure of chemical species using
short ASCII strings; calculated by ChemAxon. \cr
InChI \tab A prediction of the IUPAC International Chemical Identifier
 (InChI); imported by ChemAxon. \cr
InChIKey \tab The condensed digital representation of the IUPAC International
 Chemical Identifier (InChI); imported by ChemAxon. \cr
Polar Surface Area (PSA)	\tab A descriptor, based on the polarized atoms of
the molecule, that allows estimation of transport properties and of the
passive molecular transport through membranes of the drug; predicted by
ChemAxon.\cr
Refractivity \tab The predicted molar refractivity of the molecule, which is
strongly related to the volume of the molecules and to London dispersive
forces that play crucial part in drug-receptor interactions;
predicted by ChemAxon. \cr
Polarizability \tab The predicted relative tendency of the electron cloud
(charge distribution) of the molecule to be distorted by an external electric
 field; polarizability values predicted by ChemAxon. \cr
Rotatable Bond Count	\tab The predicted number of rotatable bonds in the
molecule; predicted by ChemAxon. Unsaturated bonds, and single bonds
connected to hydrogens or terminal atoms, single bonds of amides,
sulphonamides and those connecting two hindered aromatic rings (having at
least three ortho substituents) are considered non-rotatable. \cr
H Bond Acceptor Count	\tab A calculation of the sum of the hydrogen bond
acceptor atoms. An acceptor atom always has a lone electron pair/lone
electron pairs that is capable of establishing a H bond. Predicted by
ChemAxon. \cr
H Bond Donor Count	\tab A calculation of the sum of the atoms in the
molecule which have hydrogen bond donor property. Predicted by ChemAxon. \cr
pKa (strongest acidic)	\tab The strongest acidic pka value of the molecule;
 predicted by ChemAxon. \cr
pKa (strongest basic) \tab The strongest basic pka value of the molecule;
predicted by ChemAxon. \cr
Physiological Charge	\tab Charge of the molecule at physiological pH;
predicted by ChemAxon.\cr
Number of Rings \tab A calculation of the number of rings in the molecule;
 predicted by ChemAxon. \cr
Bioavailability \tab Fraction of administered dose that is predicted to reach
 the systemic circulation; predicted by ChemAxon.\cr
Rule of Five	\tab A reflection of the absorption or permeation of a molecule;
 considered “yes” when the molecular weight is under 500 g/mol, the value of
  logP is lower than 5, and the molecule has utmost 5 H-donor and
  10 H-acceptor atoms; predicted by ChemAxon. \cr
Ghose Filter	\tab A filter that defines drug-likeness constraints as follows:
 calculated log P is between -0.4 and 5.6, molecular weight is between
 160 and 480, molar refractivity is between 40 and 130, and the total number
 of atoms is between 20 and 70. Imported from ChemAxon. \cr
MDDR-Like Rule	\tab Indicates compliance of drug-like characteristics based
on number of rings, rigid bonds and rotatable bonds;
 calculated by ChemAxon. \cr
}
}
\keyword{datasets}
