% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Experimental_Properties_Drug}
\alias{Experimental_Properties_Drug}
\title{Drug Experimental Properties}
\format{
a tibble with 4 variables:
\describe{
  \item{kind}{Name of the property}
  \item{value}{Drug properties that have been experimentally proven}
  \item{source}{Reference to the source of this experimental data}
  \item{parent_key}{drugbank key}
}
}
\source{
\href{https://docs.drugbankplus.com/xml/}{Drugbank Documentation}
}
\usage{
Experimental_Properties_Drug
}
\description{
Drug properties that have been experimentally proven.
Each drug may have one or more experimental property.
}
\details{
The following experimental properties are provided:
\tabular{ll}{
  \strong{Property} \tab \strong{Description} \cr
  Water Solubility \tab The experimentally determined aqueous solubility of
  the molecule \cr
  Molecular Formula \tab Protein formula of Biotech drugs \cr
  Molecular Weight \tab Protein weight of Biotech drugs \cr
  Melting Point \tab The experimentally determined temperature at which the
  drug molecule changes from solid to liquid at atmospheric temperature.\cr
  Boiling Point \tab The experimentally determined temperature at which the
  drug molecule changes from liquid to gas at atmospheric temperature \cr
  Hydrophobicity \tab The ability of a molecule to repel water rather than
   absorb or dissolve water \cr
  Isoelectric Point \tab The pH value at which the net electric charge of
  a molecule is zero \cr
  caco2 Permeability \tab A continuous line of heterogeneous human epithelial
   colorectal adenocarcinoma cells, CAC02 cells are employed as a model of
   human intestinal absorption of various drugs and compounds. CAC02 cell
   permeability is ultimately an assay to measure drug absorption\cr
  pKa \tab The experimentally determined pka value of the molecule. \cr
  logP \tab The experimentally determined partition coefficient (LogP) based
   on the ratio of solubility of the molecule in 1-octanol compared
   to water\cr
  logS \tab The intrinsic solubility of a given compound is the concentration
   in equilibrium with its solid phase that dissolves into solution, given as
   the natural logarithm (LogS) of the concentration. \cr
  Radioactivity \tab The property to spontaneously emit particles
  (alpha, beta, neutron) or radiation (gamma, K capture), or both at the same
   time, from the decay of certain nuclides \cr
}
}
\keyword{datasets}
