% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{name_to_abbr}
\alias{name_to_abbr}
\title{Get state abbreviations from state names}
\usage{
name_to_abbr(
  name,
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  ties_method = c("first", "all")
)
}
\arguments{
\item{name}{Vector of state names to look up.}

\item{ignore.case, perl, fixed}{Arguments to pass to \code{grep()}, with the same
defaults as in the latter function. Hence, by default, regular expressions
are used; to match against a fixed string (no regular expressions), set
\code{fixed = TRUE}.}

\item{ties_method}{If "first", then only the first match for each name is
returned. If "all", then all matches for each name are returned.}
}
\value{
A vector of state abbreviations if \code{ties_method} equals "first", and
a list of state abbreviations otherwise.
}
\description{
Look up state abbreviations by state names (including District of Columbia
and Puerto Rico); this function is based on \code{grep()}, and hence allows for
regular expressions.
}
\examples{
name_to_abbr("Penn")
name_to_abbr(c("Penn", "New"), ties_method = "all")

}
\seealso{
\code{\link[=abbr_to_name]{abbr_to_name()}}
}
