% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_latest_data.R
\name{get_latest_data}
\alias{get_latest_data}
\title{Retrieve updated COVID Symptom Study Sweden (CSSS) data}
\usage{
get_latest_data(data_level = c("national", "county", "postcode"))
}
\arguments{
\item{data_level}{A character string specifying which data set from CSSS you want to "download". Can be "national" (default), "county", or "postcode".}
}
\value{
This function returns a \code{data.frame} containing the data for the specified level. Data returned is the last available snapshot stored within the package.
}
\description{
This function was originally designed to download the latest version of CSSS data dynamically. Due to the cessation of data updates from the COVID Symptom Study Sweden, this function now checks if locally stored data is up-to-date and notifies the user accordingly. The function will not fetch new data from online sources.
}
\details{
Note: As the COVID Symptom Study Sweden is no longer updating their data sets, this function serves as a demonstration of how data updates could be managed without needing frequent package updates. It returns the data that was last available before updates were discontinued.
}
\examples{
# The following example demonstrates how to retrieve data at the county level.
df <- get_latest_data(data_level = "county")
}
\author{
Hugo Fitipaldi
}
