% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdensity.R
\name{cdensity}
\alias{cdensity}
\title{Circular Density Curve}
\usage{
cdensity(
  f,
  radius = 1/sqrt(base::pi),
  area.prop = TRUE,
  total.area = 1,
  nlabels = 4,
  add = FALSE,
  n = 500,
  col = "red",
  xlim = NULL,
  ylim = NULL,
  main = NULL
)
}
\arguments{
\item{f}{an R function that is to be plotted as a circular density or
frequency.}

\item{radius}{the radius of the reference circle. If \code{radius = 0},
no reference circle is produced, and the centre presents the point
with zero density.}

\item{area.prop}{logical; if \code{TRUE}, an area-proportional
transformation is applied; if \code{FALSE}, a height-proportional
transformation is applied.}

\item{total.area}{a positive number specifying the total area under the
density curve. If \code{total.area = NULL}, no scaling is applied, the
plot is in the original scale. If \code{area.prop = TRUE}, the total area 
is automatically unity without scaling.}

\item{nlabels}{integer, for the number of levels to be plotted; if
\code{0}, no label is plotted.}

\item{add}{logical; if \code{TRUE}, the density curve is superimposed to
the current plot, for example, a circular histogram, a rose diagram or
a stacked dot plot that has been produced in a similar manner.}

\item{n}{the number of points to plot the density curve.}

\item{col}{the color of the density line.}

\item{xlim}{numeric vectors of length 2, giving the x coordinates
ranges.}

\item{ylim}{numeric vectors of length 2, giving the y coordinates
ranges.}

\item{main}{the main title (on top)}
}
\value{
No return value
}
\description{
Function \code{cdensity} can be used to plot 2-dimensional 
  density curves for circular data.
}
\examples{
# 600 observations from two von Mises distributions
library(circular)
x = c(rvonmises(200, circular(pi/4), 5), rvonmises(400, circular(pi), 20))
dvm = function(x, mu=0, kappa=1)   # von Mises density
  exp(kappa * cos(x - mu)) * (2 * pi * besselI(kappa, 0))^(-1)
f = function(x) 1/3 * dvm(x, pi/4, 5) + 2/3 * dvm(x, pi, 20)

cdensity(f)                # plot the density in an area-proportional manner

chist(x)                   # circular histogram
cdensity(f, add=TRUE)      # superimpose the density curve
chist(x, area=FALSE)       # height-proportional circular histogram
cdensity(f, area=FALSE, add=TRUE)   # superimpose the density curve

chist(x, radius=0)                          # rose diagrams
cdensity(f, radius=0, add=TRUE)
chist(x, radius=0, area=FALSE)
cdensity(f, radius=0, area=FALSE, add=TRUE)

}
\references{
Xu, D. and Wang, Y. (2020). Area-proportional Visualization for
Circular Data. \emph{Journal of Computational and Graphical
Statistics}, \bold{29}, 351-357.
}
\seealso{
\code{\link{cbarplot}}, \code{\link{cdotplot}}, \code{\link{chist}}
}
\author{
Danli Xu <dxu452@aucklanduni.ac.nz>, Yong Wang <yongwang@auckland.ac.nz>
}
\concept{circular density curve}
