% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_rcpp.R
\name{simulation}
\alias{simulation}
\title{Running a whole simulation of a doubly constrained gravity model}
\usage{
simulation(flows_matrix, dist_matrix, beta_offset = 0.25)
}
\arguments{
\item{flows_matrix}{a integer matrix of flows}

\item{dist_matrix}{a distance matrix containing numeric values in kilometers}

\item{beta_offset}{an offset from 0 from which to start looking for the best fit value.}
}
\value{
creates a folder based on the run_name parameter to which images and files are written.
The file run_name_best_fit.rds contain the matrices with values from the model
, and the quality of fit values for the beta values.
}
\description{
this script takes flows data, distance matrix, and a reference beta parameter
and finds the optimal beta value for the model, runs it, and returns the result and the beta of
best fit.

currently only the exp value is accepted for the cost_fun parameter.
}
\examples{

data(flows_test)
data(distance_test)

model <- simulation(flows_test,distance_test)

}
