% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expfns.R
\name{exp_memsim}
\alias{exp_memsim}
\title{Memoryless simulation for the exponential change-point hazard distribution}
\usage{
exp_memsim(n, endtime, theta, tau = NA)
}
\arguments{
\item{n}{Sample size}

\item{endtime}{Maximum study time, point at which all participants
are censored}

\item{theta}{Scale parameter \eqn{\theta}}

\item{tau}{Change-point(s) \eqn{\tau}}
}
\value{
Dataset with n participants including a survival time
and censoring indicator (0 = censored, 1 = event).
}
\description{
\code{exp_memsim} simulates time-to-event data from the exponential change-point
hazard distribution by implementing the memoryless method.
}
\details{
This function simulates time-to-event data between \eqn{K} change-points from
independent exponential distributions using the inverse CDF implemented
in \code{exp_icdf}. This method applies Type I right censoring at the endtime
specified by the user.
}
\examples{
nochangepoint <- exp_memsim( n = 10, endtime = 20, theta = 0.05)
onechangepoint <- exp_memsim(n = 10, endtime = 20,
  theta = c(0.05, 0.01), tau = 10)
twochangepoints <- exp_memsim(n = 10, endtime = 20,
  theta = c(0.05, 0.01, 0.05), tau = c(8, 12))

# Pay attention to how you parameterize your model!
# This simulates a decreasing hazard
set.seed(1245)
decreasingHazard <- exp_memsim(n = 10, endtime = 20,
  theta = c(0.05, 0.02, 0.01), tau = c(8, 12))
# This tries to fit an increasing hazard, resulting in biased estimates
cp2.nll <- function(par, tau = tau, dta = dta){
  theta1 <- par[1]
  theta2 <- par[2]
  theta3 <- par[3]
  ll <- log(theta1) * sum(dta$time < tau[1])+
        log(theta2) * sum((tau[1] <= dta$time) * (dta$time < tau[2])) +
        log(theta3) * sum((dta$time >= tau[2]) * dta$censor) -
        theta1 * sum(dta$time * (dta$time < tau[1]) +
          tau[1] * (dta$time >= tau[1])) -
        theta2 * sum((dta$time - tau[1]) * (dta$time >= tau[1]) *
          (dta$time < tau[2]) + (tau[2] - tau[1]) * (dta$time >= tau[2])) -
        theta3 * sum((dta$time - tau[2]) * (dta$time >= tau[2]))
  return(-ll)
}
optim(par = c(0.001, 0.1, 0.5), fn = cp2.nll,
      tau = c(8, 12), dta = decreasingHazard)

}
