% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/armed_bandit_helpers.R
\name{ContextualLinearBandit}
\alias{ContextualLinearBandit}
\title{Contextual Linear Bandit Environment}
\description{
Contextual Linear Bandit Environment

Contextual Linear Bandit Environment
}
\details{
An R6 class for simulating a contextual linear bandit environment with normally distributed rewards.
}
\section{Methods}{

- `initialize(k, d, list_betas, sigma = 0.1, binary_rewards = FALSE)`: Constructor.
- `post_initialization()`: Loads correct coefficients based on `sim_id`.
- `get_context(t)`: Returns context and sets internal reward vector.
- `get_reward(t, context_common, action)`: Returns observed reward for an action.
}

\section{Super class}{
\code{cramR::NA} -> \code{ContextualLinearBandit}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{rewards}}{A vector of rewards for each arm in the current round.}

\item{\code{betas}}{Coefficient matrix of the linear reward model (one column per arm).}

\item{\code{sigma}}{Standard deviation of the Gaussian noise added to rewards.}

\item{\code{binary}}{Logical, indicating whether to convert rewards into binary outcomes.}

\item{\code{weights}}{The latent reward scores before noise and/or binarization.}

\item{\code{list_betas}}{A list of coefficient matrices, one per simulation.}

\item{\code{sim_id}}{Index for selecting which simulation's coefficients to use.}

\item{\code{class_name}}{Name of the class for internal tracking.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ContextualLinearBandit-new}{\code{ContextualLinearBandit$new()}}
\item \href{#method-ContextualLinearBandit-post_initialization}{\code{ContextualLinearBandit$post_initialization()}}
\item \href{#method-ContextualLinearBandit-get_context}{\code{ContextualLinearBandit$get_context()}}
\item \href{#method-ContextualLinearBandit-get_reward}{\code{ContextualLinearBandit$get_reward()}}
\item \href{#method-ContextualLinearBandit-clone}{\code{ContextualLinearBandit$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="cramR" data-topic="NA" data-id="final"><a href='../../cramR/html/NA.html#method-NA-final'><code>cramR::NA$final()</code></a></span></li>
<li><span class="pkg-link" data-pkg="cramR" data-topic="NA" data-id="generate_bandit_data"><a href='../../cramR/html/NA.html#method-NA-generate_bandit_data'><code>cramR::NA$generate_bandit_data()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextualLinearBandit-new"></a>}}
\if{latex}{\out{\hypertarget{method-ContextualLinearBandit-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextualLinearBandit$new(
  k,
  d,
  list_betas,
  sigma = 0.1,
  binary_rewards = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{k}}{Number of arms}

\item{\code{d}}{Number of features}

\item{\code{list_betas}}{A list of true beta matrices for each simulation}

\item{\code{sigma}}{Standard deviation of Gaussian noise}

\item{\code{binary_rewards}}{Logical, use binary rewards or not}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextualLinearBandit-post_initialization"></a>}}
\if{latex}{\out{\hypertarget{method-ContextualLinearBandit-post_initialization}{}}}
\subsection{Method \code{post_initialization()}}{
Set the simulation-specific coefficients for the current simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextualLinearBandit$post_initialization()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
No return value; modifies the internal state of the object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextualLinearBandit-get_context"></a>}}
\if{latex}{\out{\hypertarget{method-ContextualLinearBandit-get_context}{}}}
\subsection{Method \code{get_context()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextualLinearBandit$get_context(t)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{Current time step}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list containing context vector `X` and arm count `k`
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextualLinearBandit-get_reward"></a>}}
\if{latex}{\out{\hypertarget{method-ContextualLinearBandit-get_reward}{}}}
\subsection{Method \code{get_reward()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextualLinearBandit$get_reward(t, context_common, action)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{Current time step}

\item{\code{context_common}}{Context shared across arms}

\item{\code{action}}{Action taken by the policy}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with reward and optimal arm/reward info
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextualLinearBandit-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ContextualLinearBandit-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextualLinearBandit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
