% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{CDS, CDS-class}
\alias{CDS, CDS-class}
\alias{CDS,}
\alias{CDS-class}
\title{CDS Class}
\description{
Class definition for the \code{CDS-Class}
}
\section{Slots}{

\describe{
\item{\code{name}}{is the name of the reference entity. Optional.}

\item{\code{contract}}{is the contract type, default SNAC}

\item{\code{RED}}{alphanumeric code assigned to the reference entity. Optional.}

\item{\code{date}}{is when the trade is executed, denoted as T. Default is
\code{Sys.Date}.}

\item{\code{spread}}{CDS par spread in bps.}

\item{\code{maturity}}{date of the CDS contract.}

\item{\code{tenor}}{of contract in number of years - 5, 3}

\item{\code{coupon}}{quoted in bps. It specifies the payment amount from}

\item{\code{recovery}}{in decimal. Default is 0.4.}

\item{\code{currency}}{in which CDS is denominated.}

\item{\code{principal}}{is the dirty \code{upfront} less the \code{accrual}.}

\item{\code{accrual}}{is the accrued interest payment.}

\item{\code{pd}}{is the approximate the default probability at time t given the
\code{spread}.}

\item{\code{price}}{is the price}

\item{\code{upfront}}{is quoted in the currency amount. Since a standard contract is
traded with fixed coupons, upfront payment is introduced to reconcile the
difference in contract value due to the difference between the fixed coupon
and the conventional par spread. There are two types of upfront, dirty and
clean. Dirty upfront, a.k.a. Cash Settlement Amount, refers to the market
value of a CDS contract. Clean upfront is dirty upfront less any accrued 
interest payment, and is also called the Principal.}

\item{\code{spread.DV01}}{measures the sensitivity of a CDS contract mark-to-market
to a parallel shift in the term structure of the par spread.}

\item{\code{IR.DV01}}{is the change in value of a CDS contract for a 1 bp parallel
increase in the interest rate curve. \code{IRDV01} is, typically, a much
smaller dollar value than \code{spreadDV01} because moves in overall
interest rates have a much smaller effect on the value of a CDS contract
than does a move in the CDS spread itself.}

\item{\code{rec.risk.01}}{is the dollar value change in market value if the recovery
rate used in the CDS valuation were increased by 1\%.}
}}

