% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{uk_serial_df}
\alias{uk_serial_df}
\title{Serial Killers of the UK (1828 - 2015)}
\format{
A data frame with 62 observations and 8 variables:
\describe{
  \item{number_of_kills}{Total number of murders committed by the serial killer (integer).}
  \item{years}{The years during which the serial killer was active (factor).}
  \item{name}{Name of the serial killer (character).}
  \item{aka}{Known aliases of the serial killer (character).}
  \item{year_start}{The first year the serial killer was active (integer).}
  \item{year_end}{The last year the serial killer was active (integer).}
  \item{date_of_first_kill}{The date when the serial killer committed their first murder (factor).}
  \item{population_million}{Population in millions at the time the serial killer was active (numeric).}
}
}
\source{
https://www.murderuk.com/
}
\usage{
data(uk_serial_df)
}
\description{
This dataset contains information about the serial killers in the UK, including their name, number of kills,
years active, and the population during their time. It provides a historical view of some of the most infamous
serial killers in the United Kingdom.
}
\details{
The dataset name has been changed to 'uk_serial_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
crimedatasets package and assists users in identifying its specific characteristics. The suffix 'df'
indicates that the dataset is a data frame. The original content has not been modified in any way.
}
