% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase_two_library.R
\name{evaluateListOfIMs}
\alias{evaluateListOfIMs}
\title{Evaluate list of rule set matrices}
\usage{
evaluateListOfIMs(D, Q, rm, im.list)
}
\arguments{
\item{D}{binary matrix of events by samples}

\item{Q}{penalty matrix of events by samples}

\item{rm}{matrix of rules ordered by phase one}

\item{im.list}{list of rule set matrices}
}
\value{
list of Js for each rule set matrix
}
\description{
Evaluate list of rule set matrices
}
\examples{
library(crso)
data(skcm)
list2env(skcm.list,envir=globalenv())
Q <- log10(P)
rm.full <- buildRuleLibrary(D,rule.thresh = 0.05) # Rule library matrix, dimension: 60 x 71
p2.im.list <- makePhaseTwoImList(D,Q,rm.full,k.max = 3,pool.sizes=c(60,20,20),max.stored=100,
              shouldPrint = TRUE)
p2.performance.list <- evaluateListOfIMs(D,Q,rm.full,p2.im.list)
}
