% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crypto_listings.R
\name{crypto_listings}
\alias{crypto_listings}
\title{Retrieves name, CMC id, symbol, slug, rank, an activity flag as well as activity dates on CMC for all coins}
\usage{
crypto_listings(
  which = "latest",
  convert = "USD",
  limit = 5000,
  start_date = NULL,
  end_date = NULL,
  interval = "day",
  quote = FALSE,
  sort = "cmc_rank",
  sort_dir = "asc",
  sleep = 0,
  wait = 60,
  finalWait = FALSE
)
}
\arguments{
\item{which}{string Shall the code retrieve the latest listing, the new listings or a historic listing?}

\item{convert}{string (default: USD) to one of available fiat prices (\code{fiat_list()}). If more
than one are selected please separate by comma (e.g. "USD,BTC"), only necessary if 'quote=TRUE'}

\item{limit}{integer Return the top n records}

\item{start_date}{string Start date to retrieve data from, format 'yyyymmdd'}

\item{end_date}{string End date to retrieve data from, format 'yyyymmdd', if not provided, today will be assumed}

\item{interval}{string Interval with which to sample data according to what \code{seq()} needs}

\item{quote}{logical set to TRUE if you want to include price data (FALSE=default)}

\item{sort}{(May 2024: currently not available) string use to sort results, possible values: "name", "symbol", "market_cap", "price",
"circulating_supply", "total_supply", "max_supply", "num_market_pairs", "volume_24h",
"volume_7d", "volume_30d", "percent_change_1h", "percent_change_24h",
"percent_change_7d". Especially useful if you only want to download the top x entries using "limit" (deprecated for "new")}

\item{sort_dir}{(May 2024: currently not available) string used to specify the direction of the sort in "sort". Possible values are "asc" (DEFAULT) and "desc"}

\item{sleep}{integer (default 0) Seconds to sleep between API requests}

\item{wait}{waiting time before retry in case of fail (needs to be larger than 60s in case the server blocks too many attempts, default=60)}

\item{finalWait}{to avoid calling the web-api again with another command before 60s are over (TRUE=default)}
}
\value{
List of latest/new/historic listings of cryptocurrencies in a tibble (depending on the "which"-switch and
whether "quote" is requested, the result may only contain some of the following variables):
\item{id}{CMC id (unique identifier)}
\item{name}{Coin name}
\item{symbol}{Coin symbol (not-unique)}
\item{slug}{Coin URL slug (unique)}
\item{date_added}{Date when the coin was added to the dataset}
\item{last_updated}{Last update of the data in the database}
\item{rank}{Current rank on CMC (if still active)}
\item{market_cap}{market cap - close x circulating supply}
\item{market_cap_by_total_supply}{market cap - close x total supply}
\item{market_cap_dominance}{market cap dominance}
\item{fully_diluted_market_cap}{fully diluted market cap}
\item{self_reported_market_cap}{is the source of the market cap self-reported}
\item{self_reported_circulating_supply}{is the source of the circulating supply self-reported}
\item{tvl_ratio}{percentage of total value locked}
\item{price}{latest average price}
\item{circulating_supply}{approx. number of coins in circulation}
\item{total_supply}{approx. total amount of coins in existence right now (minus any coins that have been verifiably burned)}
\item{max_supply}{CMC approx. of max amount of coins that will ever exist in the lifetime of the currency}
\item{num_market_pairs}{number of market pairs across all exchanges this coin}
\item{tvl}{total value locked}
\item{volume_24h}{Volume 24 hours}
\item{volume_change_24h}{Volume change in 24 hours}
\item{percent_change_1h}{1 hour return}
\item{percent_change_24h}{24 hour return}
\item{percent_change_7d}{7 day return}
\item{percent_change_30d}{30 day return}
\item{percent_change_60d}{60 day return}
\item{percent_change_90d}{90 day return}
}
\description{
This code retrieves listing data (latest/new/historic).
}
\examples{
\dontrun{
# return new listings from the last 30 days
new_listings <- crypto_listings(which="new", quote=FALSE, limit=50000)
new_listings2 <- crypto_listings(which="new", quote=TRUE, convert="BTC")

# return latest listing (last available data of all CC including quotes)
latest_listings <- crypto_listings(which="latest", quote=FALSE, limit=50000)
latest_listings2 <- crypto_listings(which="latest", quote=TRUE, convert="BTC")

# return the first 10 listings in the first week of January 2024
listings_2024w1 <- crypto_listings(which="historical", quote=TRUE,
      start_date = "20240101", end_date="20240102", interval="day", limit=10)

# only download the top 10 crypto currencies based on their market capitalization
# DOES NOT WORK ANY MORE

# for historically accurate snapshots (e.g. for backtesting crypto investments)
# you need to download the entire history on one day including price information:
listings_20200202 <- crypto_listings(which="historical", quote=TRUE,
      start_date="20200202", end_date="20200202")
listings_20240202 <- crypto_listings(which="historical", quote=TRUE,
      start_date="20240202", end_date="20240202", limit=50000)
# note the much larger amount in CCs in 2024, as well as the existence of many
more variables in the dataset
}

}
