% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/short_term_trend_sts_v1.R
\name{short_term_trend_sts_v1}
\alias{short_term_trend_sts_v1}
\title{Determine the short term trend of a timeseries}
\usage{
short_term_trend_sts_v1(sts, control = list(w = 5, alpha = 0.05))
}
\arguments{
\item{sts}{Data object of type sts.}

\item{control}{Control object, a named list with several elements.
  \describe{
    \item{w}{Length of the window that is being analyzed.}
    \item{alpha}{Significance level for change in trend.}
}}
}
\value{
sts object with the alarms slot set to 0/1 if not-increasing/increasing.
}
\description{
The method is based upon a published analytics strategy by Benedetti (2019) <doi:10.5588/pha.19.0002>.
This function has been frozen on 2024-06-24. It is designed to use sts
}
\examples{
d <- cstidy::nor_covid19_icu_and_hospitalization_csfmt_rts_v1
d <- d[granularity_time=="isoyearweek"]
sts <- surveillance::sts(
  observed = d$hospitalization_with_covid19_as_primary_cause_n, # weekly number of cases
  start = c(d$isoyear[1], d$isoweek[1]), # first week of the time series
  frequency = 52
)
x <- csalert::short_term_trend_sts_v1(
  sts,
  control = list(
    w = 5,
    alpha = 0.05
  )
)
plot(x)
}
