% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_data_baseline.R
\name{simulate_baseline_data}
\alias{simulate_baseline_data}
\title{Simulate baseline data ----
Simulation of baseline data.}
\usage{
simulate_baseline_data(
  start_date,
  end_date,
  seasonal_pattern_n,
  weekly_pattern_n,
  alpha,
  beta,
  gamma_1,
  gamma_2,
  gamma_3,
  gamma_4,
  phi,
  shift_1
)
}
\arguments{
\item{start_date}{Starting date of the simulation period.
Date is in the format of 'yyyy-mm-dd'.}

\item{end_date}{Ending date of the simulation period.
Date is in the format of 'yyyy-mm-dd'.}

\item{seasonal_pattern_n}{Number of seasonal patterns. For no seasonal pattern seasonal_pattern_n = 0. Seasonal_pattern_n = 1 represents annual pattern. Seasonal_pattern_n = 2 indicates biannual pattern.}

\item{weekly_pattern_n}{Number of weekly patterns. For no specific weekly pattern, weekly_pattern_n = 0. Weekly_pattern_n = 1 represents one weekly peak.}

\item{alpha}{The parameter is used to specify the baseline frequencies of reports}

\item{beta}{The parameter is used to specify to specify linear trend}

\item{gamma_1}{The parameter is used to specify the seasonal pattern}

\item{gamma_2}{The parameter is used to specify the seasonal pattern}

\item{gamma_3}{The parameter is used to specify day-of-the week pattern}

\item{gamma_4}{The parameter is used to specify day-of-the week pattern}

\item{phi}{Dispersion parameter. If phi =0, a Poisson model is used to simulate baseline data.}

\item{shift_1}{Horizontal shift parameter to help control over week/month peaks.}
}
\value{
A csfmt_rts_data_v1, data.table containing a time series of counts

\describe{
  \item{wday}{day-of-the week}
  \item{n}{cases}
}
}
\description{
This function simulates a time series of daily counts in the absence of outbreaks. Data is simulated using a poisson/negative binomial model as described in
Noufaily et al. (2019).
Properties of time series such as frequency of baseline observations, trend, seasonal and weekly pattern can be specified in the simulation.
}
\examples{
baseline  <- simulate_baseline_data(
start_date = as.Date("2012-01-01"),
end_date = as.Date("2019-12-31"),
seasonal_pattern_n = 1,
weekly_pattern_n = 1,
alpha = 3,
beta = 0,
gamma_1 = 0.8,
gamma_2 = 0.6,
gamma_3 = 0.8,
gamma_4 = 0.4,
phi = 4,
shift_1 = 29 )
}
