% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranks.R
\name{cstaubest}
\alias{cstaubest}
\alias{cstauworst}
\title{Confidence sets for the tau-best}
\usage{
cstaubest(
  x,
  Sigma,
  tau = 2,
  coverage = 0.95,
  stepdown = TRUE,
  R = 1000,
  na.rm = FALSE,
  seed = NA
)

cstauworst(
  x,
  Sigma,
  tau = 2,
  coverage = 0.95,
  stepdown = TRUE,
  R = 1000,
  na.rm = FALSE,
  seed = NA
)
}
\arguments{
\item{x}{vector of estimates containing estimated features by which the populations are to be ranked.}

\item{Sigma}{estimated covariance matrix of \code{x}.}

\item{tau}{the confidence set contains indicators for the elements in \code{x} whose rank is less than or equal to \code{tau}.}

\item{coverage}{nominal coverage of the confidence set. Default is 0.95.}

\item{stepdown}{logical; if \code{TRUE} (default), stepwise procedure is used, otherwise single step procedure is used. See Details section for more.}

\item{R}{number of bootstrap replications. Default is 1000.}

\item{na.rm}{logical; if \code{TRUE}, then \code{NA}'s are removed from \code{x} and \code{Sigma} (if any).}

\item{seed}{seed for bootstrap random variable draws. If set to \code{NA} (default), then seed is not set.}
}
\value{
logical vector indicating which of the elements of \code{x} are in the confidence set for the tau-best.
}
\description{
Computation of confidence sets for the identities of populations among the tau best.
}
\section{Functions}{
\itemize{
\item \code{cstauworst()}: Confidence sets for the tau-worst

Equivalent to calling \code{cstaubest} with \code{-x}.

}}
\section{Details}{

The function computes a confidence set containing indicators for the elements in \code{x} whose rank is less than or equal to \code{tau} with probability approximately equal to the nominal coverage (\code{coverage}).

The function implements the projection confidence set for the tau-best developed and described in more detail in Mogstad, Romano, Shaikh, and Wilhelm (2023).
}

\examples{
# simple simulated example:
n <- 100
p <- 10
X <- matrix(rep(1:p,n)/p, ncol=p, byrow=TRUE) + matrix(rnorm(n*p), 100, 10)
thetahat <- colMeans(X)
Sigmahat <- cov(X) / n

# confidence set for the populations that may be among the top-3 
# (with probability approximately 0.95):
cstaubest(thetahat, Sigmahat, tau=3)

# confidence set for the populations that may be among the bottom-3 
# (with probability approximately 0.95):
cstauworst(thetahat, Sigmahat, tau=3)

}
\references{
Mogstad, Romano, Shaikh, and Wilhelm (2023), "Inference for Ranks with Applications to Mobility across Neighborhoods and Academic Achievements across Countries", forthcoming at Review of Economic Studies
\href{http://dwilhelm.userweb.mwn.de/papers/cwp0323.pdf}{cemmap working paper}, \doi{10.1093/restud/rdad006}
}
