% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csfmt_rts_v1.R
\name{set_csfmt_rts_data_v1}
\alias{set_csfmt_rts_data_v1}
\alias{csfmt_rts_data_v1}
\title{Convert data.table to csfmt_rts_data_v1 (deprecated)}
\usage{
set_csfmt_rts_data_v1(x, create_unified_columns = TRUE, heal = TRUE)

csfmt_rts_data_v1(x, create_unified_columns = TRUE, heal = TRUE)
}
\arguments{
\item{x}{The data.table to be converted to csfmt_rts_data_v1}

\item{create_unified_columns}{Do you want it to create unified columns?}

\item{heal}{Do you want to impute missing values on creation?}
}
\value{
An extended \code{data.table}, which has been modified by reference and returned (invisibly).

No return value, called for side effect of replacing the current data.table with a csfmt_rts_data_v1 in place.

Returns a duplicated csfmt_rts_data_v1.
}
\description{
\code{set_csfmt_rts_data_v1} converts a \code{data.table} to \code{csfmt_rts_data_v1} by reference.
\code{csfmt_rts_data_v1} creates a new \code{csfmt_rts_data_v1} (not by reference) from either a \code{data.table} or \code{data.frame}.
}
\section{Smart assignment}{

\code{csfmt_rts_data_v1} contains the smart assignment feature for time and geography.

When the \strong{variables in bold} are assigned using \verb{:=}, the listed variables will be automatically imputed.

\strong{location_code}:
\itemize{
\item granularity_geo
\item country_iso3
}

\strong{isoyear}:
\itemize{
\item granularity_time
\item isoweek
\item isoyearweek
\item season
\item seasonweek
\item calyear
\item calmonth
\item calyearmonth
\item date
}

\strong{isoyearweek}:
\itemize{
\item granularity_time
\item isoyear
\item isoweek
\item season
\item seasonweek
\item calyear
\item calmonth
\item calyearmonth
\item date
}

\strong{date}:
\itemize{
\item granularity_time
\item isoyear
\item isoweek
\item isoyearweek
\item season
\item seasonweek
\item calyear
\item calmonth
\item calyearmonth
}
}

\section{Unified columns}{

\code{csfmt_rts_data_v1} contains 16 unified columns:
\itemize{
\item granularity_time
\item granularity_geo
\item country_iso3
\item location_code
\item border
\item age
\item sex
\item isoyear
\item isoweek
\item isoyearweek
\item season
\item seasonweek
\item calyear
\item calmonth
\item calyearmonth
\item date
}
}

\seealso{
Other csfmt_rts_data: 
\code{\link{expand_time_to}()},
\code{\link{identify_data_structure}()},
\code{\link{remove_class_csfmt_rts_data}()},
\code{\link{set_csfmt_rts_data_v2}()},
\code{\link{unique_time_series}()}
}
\concept{csfmt_rts_data}
