% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csvwr.R
\name{read_csvw}
\alias{read_csvw}
\title{Read CSV on the Web}
\usage{
read_csvw(filename, metadata = NULL)
}
\arguments{
\item{filename}{a path for a csv table or a json metadata document}

\item{metadata}{optional user metadata}
}
\value{
csvw metadata list, with a \code{dataframe} property added to each table
}
\description{
If the argument to \code{filename} is a json metadata document, this will be used to find csv files for
each table using the value of \code{csvw:url}.
}
\details{
If the argument to \code{filename} is a csv file, and no \code{metadata} is provided, an attempt is made to
derive metadata.

If the argument to \code{filename} is a csv file, and the \code{metadata} is provided, then the given csv will
override the value of \code{csvw:url}.

The csvw metadata is returned as a list. In each table in the table group, an element named
\code{dataframe} is added which provides the contents of the csv table parsed into a data frame using
the table schema.
}
\examples{
\dontrun{
read_csvw("metadata.json")
read_csvw("table.csv", "metadata.json")
}
}
