% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read.ctf}
\alias{read.ctf}
\title{Read CTF data}
\usage{
read.ctf(location, columns, nrows)
}
\arguments{
\item{location}{location of the CTF data, either a file path to a CTF metadata JSON file, or a directory containing a single CTF metadata JSON file.}

\item{columns}{names of the columns to read.
If missing, then read in all columns.}

\item{nrows}{integer, the maximum number of rows to read in.
If missing, then read in all rows.}
}
\value{
data frame
}
\description{
Read external CTF data into the corresponding R data frame.
}
\examples{
# An example CTF metadata file included in this package
d <- system.file("extdata", "vgsales", "vgsales-metadata.json", package = "ctf")

# Read all the rows and columns
vgsales <- read.ctf(d)

# Read 10 rows of two columns, Name and Rank
vgsales2 <- read.ctf(d, columns = c("Name", "Rank"), nrows = 10)
}
\seealso{
\code{\link{write.ctf}} to write CTF
}
