% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_events.R
\name{get_events}
\alias{get_events}
\title{Get the events for a device.}
\usage{
get_events(device_id, date_from, date_to = NULL, num_rows = NULL,
  parse_json = TRUE)
}
\arguments{
\item{device_id}{The device id.}

\item{date_from}{The starting datetime.}

\item{date_to}{The ending datetime.}

\item{num_rows}{The number of records to return.}

\item{parse_json}{If TRUE, parse the JSON object into a data frame.}
}
\value{
A \code{data.frame} if \code{parse_json = TRUE},
and a character string otherwise.
}
\description{
Get the events for a device.
}
\details{
The datetime fields \code{date_from} and \code{date_from} are expected to be
strings in the format "YYYY-MM-DDTHH:MM:SSZ".

If \code{date_to} is null, it is set to the current time.

If num_rows and both dates are specified, the lesser of the two ranges is returned.

If \code{parse_json} is TRUE, the JSON object is parsed using \code{jsonlite::fromJSON}
before being returned. The data is converted to a single flattened data frame.
If a page does not contain any events, it does not get added to the data frame.

If \code{parse_json} is FALSE, the JSON object is returned as a JSON string.
For queries with multiple pages, a list of such objects is returned. Each
element in this list contains up to 2000 records.

Get the events for a device for a time period.
}
\examples{
\donttest{
get_events(device_id, date_from = "2019-09-30T20:00:00Z")
}
}
\references{
\href{https://cumulocity.com/guides/reference/events/}{Cumulocity Events API}
}
\author{
Dmitriy Bolotov
}
