% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7-Path.R
\name{path_shape}
\alias{path_shape}
\title{Path along a Shape}
\usage{
path_shape(mat, cycle = TRUE, n = 30)
}
\arguments{
\item{mat}{an Nx2 matrix of \code{(row, col)} coordinates}

\item{cycle}{logical value determining whether to the first and last coordinates}

\item{n}{number of points along each edge to calculate}
}
\value{
Nx2 matrix of \code{(row, column)} coordinates
}
\description{
Calculate the path of a shape given supplied vertices.
}
\examples{
# Right Triangle
path_shape(rbind(
  c(10,1),
  c(10,10),
  c(1,1)
), cycle=TRUE)

}
\seealso{
Other path-fitting functions: 
\code{\link{path_arc}()},
\code{\link{path_bezier}()},
\code{\link{path_circle}()},
\code{\link{path_ellipse}()},
\code{\link{path_fill}()},
\code{\link{path_fn}()},
\code{\link{path_intersection}()},
\code{\link{path_lerp}()},
\code{\link{path_ray}()},
\code{\link{path_rect}()}
}
\concept{path-fitting functions}
