% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawDiagram_fns.R
\name{drawDiagram}
\alias{drawDiagram}
\title{drawDiagram}
\usage{
drawDiagram(findDesign.output, print.row = NULL, xmax = NULL, ymax = NULL)
}
\arguments{
\item{findDesign.output}{Output from either the function singlearmDesign or find2stageDesigns}

\item{print.row}{Choose a row number to directly obtain a plot and stopping boundaries for a particular design realisation. Default is NULL.}

\item{xmax, ymax}{Choose values for the upper limits of the x- and y-axes respectively. Helpful for comparing two design realisations. Default is NULL.}
}
\value{
The output is a list of two elements. The first, $diagram, is a ggplot2 object showing how the trial should proceed: when to to undertake an interim analysis, that is, when to check if a stopping boundary has been reached (solid colours) and what decision to make at each possible point (continue / go decision / no go decision). The second list element, $bounds.mat, is a data frame containing three columns: the number of participants at which to undertake an interim analysis (m), and the number of responses at which the trial should stop for a go decision (success) or a no go decision (fail).
}
\description{
This function produces both a data frame and a diagram of stopping boundaries.
The function takes a single argument: the output from the function singlearmDesign.
If the supplied argument contains more than one admissible designs, the user is offered a choice of which design to use.
}
\examples{
output <- singlearmDesign(nmin = 30,
 nmax = 30,
 C = 5,
 p0 = 0.1,
 p1 = 0.4,
 power = 0.8,
 alpha = 0.05)
 dig <- drawDiagram(output, print.row = 2)
}
\author{
Martin Law, \email{martin.law@mrc-bsu.cam.ac.uk}
}
