% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve.R
\name{curve}
\alias{curve}
\title{Reserve demand curve}
\usage{
curve(x, y, type = "logistic", dummy = NULL, q = NULL, ...)
}
\arguments{
\item{x}{A matrix of explanatory variables. Excess reserve must be the first input.Additional regressor follow (optional).}

\item{y}{A vector of normalised interest rates.}

\item{type}{The type of the reserve demand curve. This can be any of \code{logistic}, \code{redLogistic}, \code{fixLogistic}, \code{doubleExp}, \code{exponential}, \code{fixExponential}, \code{arctan}, \code{linear}. See details in \code{\link{curve}}}

\item{dummy}{Optional input to signify a regime change (vertical shifts in the curve). Must be a vector of equal length to the rows of \code{x}. If not needed use \code{NULL}.}

\item{q}{Target interval. This is a scalar below 1, for example 0.9 is the 90\% interval. If \code{NULL} then no quantiles are estimated.}

\item{...}{Additional arguments passed to optimiser \code{\link{curveopt}}.}
}
\value{
Returns a model of class \code{curvir}. This includes
\itemize{
 \item \code{type} the type of the curve.
 \item \code{constant} a logical indicating the use of a constant.
 \item \code{w} a list including: \code{mean} the curve parameters for the mean of the curve, \code{upper} and \code{lower} the parameters for the curve at the upper and lower intervals.
 \item \code{data} a list including the \code{y}, \code{x}, and \code{dummy} used for the fitting of the curve.
 \item \code{mse} the MSE from the fitting of the curve (the mean only).
 \item \code{q} the interval used in the fitting of the curve.
}
}
\description{
Fits the reserve demand curve between excess reserves and normalised rates
}
\details{
For a description of the parametric curves, see the provided reference. Below we list their functions:
\itemize{
 \item \code{logisitc} (Logistic) \deqn{r_i = \alpha + \kappa / (1 - \beta e^{g(\bm{C}_i)}) + \varepsilon_i}
 \item \code{redLogistic} (Reduced logistic) \deqn{r_i = \alpha + 1 / (1 - \beta e^{g(\bm{C}_i)}) + \varepsilon_i}
 \item \code{fixLogistic} (Fixed logistic) \deqn{r_i = \alpha + 1 / (1 - e^{g(\bm{C}_i)}) + \varepsilon_i}
 \item \code{doubleExp} (Double exponential) \deqn{r_i = \alpha + \beta e^{\rho e^{g(\bm{C}_i)}} + \varepsilon_i}
 \item \code{exponential} (Exponential) \deqn{r_i = \alpha + \beta e^{g(\bm{C}_i)} + \varepsilon_i}
 \item \code{fixExponential} (Fixed exponential) \deqn{r_i = \beta e^{g(\bm{C}_i)} + \varepsilon_i}
 \item \code{arctan} (Arctangent) \deqn{r_i = \alpha + \beta \arctan ( g(\bm{C}_i))  + \varepsilon_i}
 \item \code{linear} (Linear) \deqn{r_i = g(\bm{C}_i) + \varepsilon_i}
}
And \eqn{g(\bm{C}) = c + \bm{C} w_g}, where \eqn{\alpha}, \eqn{\beta}, \eqn{\kappa}, \eqn{\rho} are curve parameters,
\eqn{c} is a constant togglable by \code{constant}, \eqn{\bm{C}} are the regressors including the excess reserves. \eqn{w_g} their coefficients, and finally \eqn{\varepsilon_i} is the error term of the curve.
}
\note{
An additional column for the constant is automatically generated, unless requested otherwise.
}
\examples{
\dontshow{
  rate <- head(ecb$rate,10)
  x <- ecb$x[1:10,1,drop=FALSE]
  curve(x,rate,rep=1,type="fixExponential")
}
\donttest{
  # Use ECB example data
  rate <- ecb$rate
  x <- ecb$x[,1,drop=FALSE]
  curve(x,rate)

  # An arctangent curve
  curve(x,rate,type="arctan")
 }

}
\references{
Chen, Z., Kourentzes, N., & Veyrune, R. (2023). \href{https://www.imf.org/en/Publications/WP/Issues/2023/09/01/Modeling-the-Reserve-Demand-to-Facilitate-Central-Bank-Operations-538754}{Modeling the Reserve Demand to Facilitate Central Bank Operations.} IMF Working Papers, 2023(179).
}
\seealso{
\code{\link{predict.curvir}}, \code{\link{plot.curvir}}, and \code{\link{curveopt}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
