% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify.R
\name{cvfit}
\alias{cvfit}
\title{Automatically select curve type and explanatory variables}
\usage{
cvfit(
  x,
  y,
  folds = 10,
  constant = c(TRUE, FALSE),
  sign = NULL,
  reps = 3,
  parallel = c(FALSE, TRUE),
  usepbapply = c(FALSE, TRUE),
  alltype = c("logistic", "redLogistic", "doubleExp", "exponential", "arctan", "linear"),
  search = c("backward", "forward"),
  wsel = c("select", "combine"),
  dummy = NULL
)
}
\arguments{
\item{x}{A matrix of explanatory variables. Excess reserve must be the first input.Additional regressor follow (optional).}

\item{y}{A vector of normalised interest rates.}

\item{folds}{Folds to use for cross-validation.}

\item{constant}{A logical (\code{TRUE} or \code{FALSE}) whether to include a constant or not.}

\item{sign}{A vector of equal length to the number of additional regressors in \code{x} (excluding the constant (if used) and the excess reserves) of positive and negative values (any) that will be used to obtain signs to restrict the values of the estimated parameters. Use \code{NULL} for no restrictions.}

\item{reps}{Number of repetitions for the particle swarm optimisation.}

\item{parallel}{Initialise and use parallel processing for the cross-validation. Note that the maximum number of cores that will be used is equal to the alternative types of curves that are evaluated (\code{alltype}).}

\item{usepbapply}{A logical to indicate whether to use pbapply to report on the parallel calculation progress. Note that pbapply does not support load balancing.}

\item{alltype}{A vector of the curve types to consider in the selection process.}

\item{search}{Search strategy for variable inclusion. With \code{forward} the model starts from no explanatory variables, and evaluates potential additions. With \code{backward} the model starts with all variables and evaluates for potential exclusions.}

\item{wsel}{Use the minimum error set of parameters (\code{select}) or the combination of the pool parameters using the heuristic in Kourentzes et al., (2019) (\code{combine}).}

\item{dummy}{Optional input to signify a regime change (vertical shifts in the curve). Must be a vector of equal length to the rows of \code{x}. If not needed use \code{NULL}.}
}
\value{
Returns a list with the recommended variable selection choice:
\itemize{
 \item \code{type} the type of selected curve.
 \item \code{keep} a logical vector with which variables to keep.
 \item \code{varRes} the result from \code{\link{varselect}} for each evaluated curve type.
 \item \code{cvIndex} a matrix detailing how the sample was split for the cross-validation. First column is the fold number and second column is the index of the observation.
}
Use \code{\link{cvfitplot}} to visualise the output.
}
\description{
Using cross-validation automatically select explanatory variables jointly with curve type.
When running \code{cvfit} there is no need to use \code{\link{varselect}} separately.
}
\examples{
\donttest{
  # Use ECB example data
  rate <- ecb$rate
  x <- ecb$x[,1:3,drop=FALSE]
  cvKeep <- cvfit(x,rate,folds=5,alltype=c("logistic","arctan"),parallel=TRUE)
  # Print result
  print(cvKeep)
  # Fit curve with the selected variables
  curve(x[,cvKeep$keep,drop=FALSE],rate,type=cvKeep$type)
}

}
\references{
Chen, Z., Kourentzes, N., & Veyrune, R. (2023). \href{https://www.imf.org/en/Publications/WP/Issues/2023/09/01/Modeling-the-Reserve-Demand-to-Facilitate-Central-Bank-Operations-538754}{Modeling the Reserve Demand to Facilitate Central Bank Operations.} IMF Working Papers, 2023(179).
}
\seealso{
\code{\link{cvfitplot}}, \code{\link{curve}}, and \code{\link{varselect}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
