% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-magma.R
\name{Magma}
\alias{Magma}
\alias{Myrio}
\alias{Myrio_log}
\title{Magma model (Witt et al., submitted)}
\usage{
Magma(growth = c("exp", "log"))

Myrio()

Myrio_log()
}
\arguments{
\item{growth}{\code{character}, growth model to simulate: \code{"exp"} for exponential
growth or \code{"log"} for logistic growth. Default is \code{"exp"}.}
}
\value{
an S4 object of type \code{Magma}
}
\description{
The \emph{Magma} model interprets the Tier 2C version of the \emph{Lemna} model by
\link[=Lemna_SETAC]{Klein et al. (2021)}, as a generic macrophyte model.
It is mathematically equivalent to the Tier 2C version of the model
by Klein et al. (2021) with the recommended Tier 2C settings \code{k_photo_fixed=TRUE}
and \code{k_resp=0}.
}
\details{
In particular, the growth model is a simple exponential growth model,
which is considered to be the typical situation for a laboratory macrophyte
study. Instead of frond numbers as for Lemna, the biomass is also returned as
total shoot length (\emph{TSL}) in simulation results. Consequently, the model has
the additional parameter \code{r_DW_TSL} (dry weight per total shoot length ratio)
instead of \code{r_DW_FN} (dry weight per frond number ratio). A model variant
with an option for logistic growth is provided as well.
}
\section{State variables}{

The model has two state variables:
\itemize{
\item \code{BM}, Biomass (g dw)
\item \code{M_int}, Mass of toxicant in plant population (ng)
}
}

\section{Model parameters}{

The growth model can either simulate exponential growth (the default) or
logistic growth. For logistic growth, an additional parameter \code{D_L} describing
the limit density or carrying capacity needs to be provided.
\itemize{
\item Growth model
\itemize{
\item \code{mu_control}, Maximum photosynthesis rate (d-1), default: \code{0.47}
\item (optional) \code{D_L}, Limit density (g dw)
}
\item Concentration response (Toxicodynamics)
\itemize{
\item \code{EC50_int}, Internal concentration resulting in 50\% effect (ug L-1)
\item \code{E_max}, Maximum inhibition (-), default: \code{1}
\item \code{b}, Slope parameter (-)
}
\item Internal concentration (Toxicokinetics)
\itemize{
\item \code{P}, Permeability (cm d-1)
\item \code{r_A_DW}, Area per dry-weight ratio (cm2 g-1), default: \code{1000}
\item \code{r_FW_DW}, Fresh weight per dry weight ratio (-), default: \code{16.7}
\item \code{r_FW_V}, Fresh weight density (g cm-3), default: \code{1}
\item \code{r_DW_TSL}, Dry weight per total shoot length ratio  (g dw cm-1)
\item \code{K_pw}, Partitioning coefficient plant:water (-), default: \code{1}
\item \code{k_met}, Metabolisation rate (d-1), default: \code{0}
}
}
}

\section{Environmental factors}{


None.
}

\section{Parameter boundaries}{

Default values for parameter boundaries are set for all parameters by expert
judgement, for calibration purposes. Values can be modified using \code{\link[=set_bounds]{set_bounds()}}.
}

\section{Simulation output}{

Simulation results will contain the state variables biomass (\code{BM}) and
mass of internal toxicant (\code{M_int}).

It is possible to amend the output of \code{\link[=simulate]{simulate()}} with additional model
quantities that are not state variables, for e.g. debugging purposes or to
analyze model behavior. To enable or disable additional outputs, use the
optional argument \code{nout} of \code{\link[=simulate]{simulate()}}. As an example, set \code{nout=2} to
enable reporting of total shoot length (\code{TSL}) and internal concentration
(\code{C_int}). Set \code{nout=0} to disable additional outputs. The default is \code{nout=1}.

The available output levels are as follows:
\itemize{
\item \code{nout} >= 1: \code{TSL}, total shoot length (cm)
\item \code{nout} >= 2: \code{C_int}, internal concentration (ug L-1)
\item \code{nout} >= 3: \code{f_photo}, photosynthesis dependency function (-)
\item \code{nout} >= 4: \code{C_int_unb}, unbound internal concentration (ug L-1)
\item \code{nout} >= 5: \code{C_ext}, external concentration (ug L-1)
\item \code{nout} >= 6: \code{dBM}, biomass derivative (g dw d-1)
\item \code{nout} >= 7: \code{dM_int}, mass of toxicant in plants derivative (ng d-1)
}
}

\section{Solver settings}{

The arguments to ODE solver \code{\link[deSolve:ode]{deSolve::ode()}} control how model equations
are numerically integrated. The settings influence stability of the numerical
integration scheme as well as numerical precision of model outputs. Generally, the
default settings as defined by \emph{deSolve} are used, but all \emph{deSolve} settings
can be modified in \emph{cvasi} workflows by the user, if needed. Please refer
to e.g. \code{\link[=simulate]{simulate()}} on how to pass arguments to \emph{deSolve} in \emph{cvasi}
workflows.

Some default settings of \emph{deSolve} were adapted for this model by expert
judgement to enable precise, but also computationally efficient, simulations
for most model parameters. These settings can be modified by the user,
if needed:
\itemize{
\item \code{hmax = 0.1}\if{html}{\out{<br>}}
Maximum step length in time suitable for most simulations.
}
}

\section{Effects}{

Supported effect endpoints include \emph{BM} (biomass) and \emph{r} (average
growth rate during simulation). The effect on biomass is calculated from
the last state of a simulation. Be aware that endpoint \emph{r} is incompatible
with biomass transfers.
}

\section{Biomass transfer}{

Models supporting biomass transfer can be instructed to move a fixed amount
of biomass to a new medium after a period of time. This feature replicates
a procedure occurring in e.g. \emph{Lemna} effect studies and may be necessary to
recreate study results.

The biomass transfer feature assumes that always a fixed amount of
biomass is transferred. Transfers can occur at any fixed point in time or
in regular intervals. During a transfer, the biomass is reset to the
transferred amount and additional compartments can be scaled 1:1 accordingly,
to e.g. reflect the change in internal toxicant mass when biomass is modified.
Transfer settings can be modified using \code{\link[=set_transfer]{set_transfer()}}.

If a transfer occurs, simulation results of that time point will report the model state
\strong{before} the transfer. Be aware that if transfers are defined using the
\code{interval} argument, the transfers will always occur relative to time point
zero (\code{t = 0}). As an example, setting a regular transfer of seven days,
\code{interval =  7}, will result at transfers occurring at time points which are
integer multiplicates of seven, such as \code{t=0}, \code{t=7}, \code{t=14} and so forth.
The starting and end times of a scenario do not influece \strong{when} a regular
transfer occurs, only \strong{if} it occurs.
}

\references{
Witt et al., submitted

Klein J., Cedergreen N., Heine S., Reichenberger S., Rendal C.,
Schmitt W., Hommen U., 2021: \emph{Refined description of the Lemna TKTD growth model
based on Schmitt et al. (2013) - equation system and default parameters}.
Report of the working group \emph{Lemna} of the SETAC Europe Interest Group Effect
Modeling. Version 1.1, uploaded on 09 May 2022.
https://www.setac.org/group/effect-modeling.html
}
\seealso{
\link{Macrophyte-models}, \link{Lemna-models}, \link{Transferable}, \link{Scenarios}

Other macrophyte models: 
\code{\link{Lemna_SETAC}()},
\code{\link{Lemna_Schmitt}()},
\code{\link{Macrophyte-models}}
}
\concept{macrophyte models}
