% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_space.R
\name{explore_space}
\alias{explore_space}
\title{Explore parameter space}
\usage{
explore_space(
  x,
  par,
  res,
  output,
  data,
  sample_size = 1000,
  max_iter = 30,
  nr_accept = 100,
  sample_factor = 1.2,
  individual = FALSE,
  log_scale = FALSE,
  data_type = c("continuous", "count"),
  max_runs = deprecated(),
  ...
)
}
\arguments{
\item{x}{a list of \link{caliset} objects}

\item{par}{best fit parameters from joined calibration}

\item{res}{output of \code{\link[=lik_profile]{lik_profile()}} function}

\item{output}{character vector, name of output column of \code{\link[=simulate]{simulate()}} that
is used in calibration}

\item{data}{only needed if \code{x} is a \link{scenario}}

\item{sample_size}{number of samples to draw from each parameter interval}

\item{max_iter}{max number of iterations to redraw samples (within a smaller space), and repeat the process}

\item{nr_accept}{threshold for number of points sampled within the inner circle}

\item{sample_factor}{multiplication factor for sampling (95\% interval * sample factor)}

\item{individual}{if \code{FALSE} (default), the log likelihood is calculated across
the whole dataset. Alternatively, if \code{TRUE}, log likelihoods are calculated for
each (group of) \emph{set}(s) individually.}

\item{log_scale}{\code{FALSE} (default), option to calculate the log likelihood on a
log scale (i.e., observations and predictions are log transformed during calculation)}

\item{data_type}{Character argument, \code{"continuous"} (default) or \code{"count"}, to specify the data type
for the log likelihood calculations.}

\item{max_runs}{\emph{deprecated} alias for \code{max_iter} parameter}

\item{...}{additional parameters passed through to \code{\link[=simulate]{simulate()}}}
}
\value{
a list containing a plot to explore the parameter space, and the \code{data.frame}
supporting it
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The function is aimed at getting an idea of how the parameter space
of a model behaves, so that parameter identifiability problems and correlations
between parameters can be explored. Therefore, the function samples a large
number of parameter sets by randomly drawing from each parameter's 95\%
confidence interval (generated by \code{\link[=lik_profile]{lik_profile()}}). It then
checks how many of the parameter sets are within acceptable limits by comparing
the likelihood ratio of a parameter set vs. the original parameter set against
a chi-square distribution as degrees of freedom (df) the total number of profile
parameters (outer rim) or one df (inner rim). If needed, the function resamples
until at least \code{nr_accept} parameters sets are within the inner rim
}
\examples{
\donttest{
library(dplyr)
# Example with Lemna model - physiological params
# Before applying the function, a model needs to be calibrated and its parameters profiled
# Inputs for likelihood profiling

# observations - control run
obs <- schmitt2013 \%>\%
  filter(trial == "T0")

# parameters after calibration
params <- c(
  k_phot_max = 5.663571,
  k_resp = 1.938689,
  Topt = 26.7
)

# set parameter boundaries (if different from defaults)
bounds <- list(
  k_resp = list(0, 10),
  k_phot_max = list(0, 30),
  Topt = list(20, 30)
)

# update metsulfuron
myscenario <- metsulfuron \%>\%
  set_init(c(BM = 1.2, E = 1, M_int = 0)) \%>\%
  set_param(list(
    k_0 = 5E-5,
    a_k = 0.25,
    BM50 = 17600,
    mass_per_frond = 0.1
  )) \%>\%
  set_noexposure() \%>\%
  set_param(params) \%>\%
  set_bounds(bounds)

# Likelihood profiling
res <- lik_profile(
  x = myscenario,
  data = obs,
  output = "FrondNo",
  par = params,
  refit = FALSE,
  type = "fine",
  method = "Brent"
)
# plot
plot(res)

# parameter space explorer
set.seed(1) # for reproducibility
res_space <- explore_space(
  x = myscenario,
  data = obs,
  par = params,
  res = res,
  output = "FrondNo",
  sample_size = 1000,
  max_iter = 20,
  nr_accept = 100)

plot(res_space)

}
}
\seealso{
\link{plot.param_space}
}
