% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fx.R, R/model-lemna_setac.R, R/model-magma.R,
%   R/model-algae.R, R/model-guts.R, R/model-guts_red.R
\name{fx}
\alias{fx}
\alias{fx,ANY-method}
\alias{fx,ScenarioSequence-method}
\alias{fx,Lemna-method}
\alias{fx,Magma-method}
\alias{fx,Algae-method}
\alias{fx,GutsSd-method}
\alias{fx,GutsIt-method}
\alias{fx,GutsRedSd-method}
\alias{fx,GutsRedIt-method}
\title{Generic to calculate effects for a particular scenario}
\usage{
fx(scenario, ...)

\S4method{fx}{ANY}(scenario, ...)

\S4method{fx}{ScenarioSequence}(scenario, ...)

\S4method{fx}{Lemna}(scenario, ...)

\S4method{fx}{Magma}(scenario, ...)

\S4method{fx}{Algae}(scenario, ...)

\S4method{fx}{GutsSd}(scenario, ...)

\S4method{fx}{GutsIt}(scenario, ...)

\S4method{fx}{GutsRedSd}(scenario, ...)

\S4method{fx}{GutsRedIt}(scenario, ...)
}
\arguments{
\item{scenario}{\link{scenario} object}

\item{...}{additional parameters}
}
\value{
numeric named vector
}
\description{
Generic to calculate effects for a particular scenario
}
\section{Methods (by class)}{
\itemize{
\item \code{fx(ANY)}: Use state variables at end of simulation

\item \code{fx(ScenarioSequence)}: Wrapper for \link[=sequence]{sequences}

\item \code{fx(Lemna)}: Effect at end of simulation of \link{Lemna-models}

\item \code{fx(Magma)}: Effect at end of simulation of \link{Magma} scenarios

\item \code{fx(Algae)}: Effect at end of simulation of \link{Algae-models}

\item \code{fx(GutsSd)}: Calculates lethality of \link{GUTS-SD} scenarios

\item \code{fx(GutsIt)}: Calculates lethality of \link{GUTS-IT} scenarios

\item \code{fx(GutsRedSd)}: Calculates lethality of \link{GUTS-RED-SD} scenarios

\item \code{fx(GutsRedIt)}: Calculates lethality of \link{GUTS-RED-IT} scenarios

}}
