% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_indicator_types}
\alias{cvd_indicator_types}
\title{Retrieve available indicator types}
\usage{
cvd_indicator_types()
}
\value{
A tibble of indicator types with the following columns:
\describe{
\item{IndicatorTypeID}{Integer. Unique identifier for the indicator type.}
\item{IndicatorTypeName}{Character. Name of the indicator type (e.g., "Standard", "Outcomes").}
}
}
\description{
Returns a tibble of indicator type IDs and their corresponding names, used to categorise CVD indicators in the CVDPREVENT API. This function is primarily a helper for \code{\link[=cvd_time_period_list]{cvd_time_period_list()}}, which accepts \code{indicator_type_id} as an optional parameter.
}
\note{
This function may take longer than 5 seconds to complete due to API response time.
}
\examples{
# NB, the following example is not tested because it takes longer than
# expected to return the results

# List available indicator types
\donttest{cvd_indicator_types()}

}
\seealso{
\code{\link[=cvd_time_period_list]{cvd_time_period_list()}}
}
