library(cvms)
context("multiclass_probability_tibble")

# Diagnosis by score

test_that("multiclass_probability_tibble() works", {

  xpectr::set_test_seed(1)

  ## Testing 'multiclass_probability_tibble( num_classes =...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_12655 <- multiclass_probability_tibble(
      num_classes = 3,
      num_observations = 10,
      apply_softmax = TRUE,
      class_name = "CL_",
      add_predicted_classes = TRUE,
      add_targets = TRUE
    )
  # Testing class
  expect_equal(
    class(output_12655),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12655[["CL_1"]],
    c(0.38133, 0.44361, 0.20276, 0.37231, 0.4154, 0.28421, 0.33551,
      0.24125, 0.37819, 0.33276),
    tolerance = 1e-4)
  expect_equal(
    output_12655[["CL_2"]],
    c(0.24143, 0.35673, 0.38782, 0.2095, 0.34716, 0.43296, 0.42721,
      0.23714, 0.31526, 0.28792),
    tolerance = 1e-4)
  expect_equal(
    output_12655[["CL_3"]],
    c(0.37724, 0.19965, 0.40943, 0.41819, 0.23744, 0.28283, 0.23728,
      0.52161, 0.30655, 0.37931),
    tolerance = 1e-4)
  expect_equal(
    output_12655[["Predicted Class"]],
    c("CL_1", "CL_1", "CL_3", "CL_3", "CL_1", "CL_2", "CL_2", "CL_3",
      "CL_1", "CL_3"),
    fixed = TRUE)
  expect_equal(
    output_12655[["Target"]],
    c("CL_3", "CL_3", "CL_2", "CL_3", "CL_1", "CL_3", "CL_1", "CL_1",
      "CL_3", "CL_2"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_12655),
    c("CL_1", "CL_2", "CL_3", "Predicted Class", "Target"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12655),
    c("numeric", "numeric", "numeric", "character", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12655),
    c("double", "double", "double", "character", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12655),
    c(10L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12655)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'multiclass_probability_tibble( num_classes =...'     ####

})

test_that("fuzz testing multiclass_probability_tibble()", {
  xpectr::set_test_seed(42)

  rcertain <- function(n) {
    (runif(n, min = 1, max = 100)^1.4) / 100
  }

  rwrong <- function(n) {
    runif(n-2)
  }

  # Generate expectations for 'multiclass_probability_tibble'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = multiclass_probability_tibble,
  #   args_values = list(
  #     "num_classes" = list(3, 2, 0, -1, NA),
  #     "num_observations" = list(7, 0, -1, NA),
  #     "apply_softmax" = list(TRUE, FALSE, NA, 1),
  #     "FUN" = list(runif, rcertain, rwrong, identity, NA),
  #     "class_name" = list("class_", "CL_", 1, NA),
  #     "add_predicted_classes" = list(FALSE, TRUE, 1, NA),
  #     "add_targets" = list(FALSE, TRUE, 1, NA)
  #   ),
  #   indentation = 2
  # )


  ## Testing 'multiclass_probability_tibble'                                  ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing multiclass_probability_tibble(num_classes = ...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["class_1"]],
    c(0.47747, 0.36249, 0.22133, 0.45891, 0.34166, 0.28111, 0.3571),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["class_2"]],
    c(0.21884, 0.27394, 0.33649, 0.31613, 0.36915, 0.42595, 0.22071),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["class_3"]],
    c(0.30368, 0.36356, 0.44218, 0.22496, 0.28919, 0.29294, 0.42219),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("class_1", "class_2", "class_3"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(7L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: num_classes = 2
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- multiclass_probability_tibble(num_classes = 2, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE)
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["class_1"]],
    c(0.68571, 0.56957, 0.39677, 0.59211, 0.48067, 0.39758, 0.61802),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["class_2"]],
    c(0.31429, 0.43043, 0.60323, 0.40789, 0.51933, 0.60242, 0.38198),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("class_1", "class_2"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(7L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: num_classes = 0
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 0, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'num_classes': Must be >= 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: num_classes = -1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = -1, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'num_classes': Must be >= 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: num_classes = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = NA, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'num_classes': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: num_classes = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = NULL, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'num_classes': Must be of type 'count', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # TODO Should fail with next xpectr?
  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: num_observations = 0
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 0, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'num_observations': Must be >= 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: num_observations = -1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = -1, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'num_observations': Must be >= 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: num_observations = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = NA, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'num_observations': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: num_observations = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = NULL, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'num_observations': Must be of type 'count', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: apply_softmax = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = 1, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'apply_softmax': Must be of type 'logical flag', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: apply_softmax = FALSE
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = FALSE, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE)
  # Testing class
  expect_equal(
    class(output_17191),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17191[["class_1"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["class_2"]],
    c(0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["class_3"]],
    c(0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17191),
    c("class_1", "class_2", "class_3"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17191),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17191),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17191),
    c(7L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17191)),
    character(0),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: apply_softmax = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = NA, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'apply_softmax': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: apply_softmax = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = NULL, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'apply_softmax': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: FUN = rcertain
  xpectr::set_test_seed(42)
  # Assigning output
  output_14622 <- multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = rcertain, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE)
  # Testing class
  expect_equal(
    class(output_14622),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14622[["class_1"]],
    c(0.96237, 0.46899, 0.00612, 0.92939, 0.32236, 0.03746, 0.20354),
    tolerance = 1e-4)
  expect_equal(
    output_14622[["class_2"]],
    c(0.00552, 0.05011, 0.09658, 0.06059, 0.57634, 0.91284, 0.00862),
    tolerance = 1e-4)
  expect_equal(
    output_14622[["class_3"]],
    c(0.03212, 0.4809, 0.8973, 0.01002, 0.10129, 0.0497, 0.78783),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14622),
    c("class_1", "class_2", "class_3"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14622),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14622),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14622),
    c(7L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14622)),
    character(0),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: FUN = rwrong
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = rwrong, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("1 assertions failed:\n * the output of 'FUN' did not have length 'num_classes' * 'num_observations'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: FUN = identity
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = identity, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * the output of 'FUN' did not have length 'num_classes' * 'num_observations'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: FUN = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11174 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = NA, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'FUN': Must be a function, not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: FUN = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14749 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = NULL, class_name = "class_", add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'FUN': Must be a function, not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: class_name = "CL_"
  xpectr::set_test_seed(42)
  # Assigning output
  output_15603 <- multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = "CL_", add_predicted_classes = FALSE, add_targets = FALSE)
  # Testing class
  expect_equal(
    class(output_15603),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_15603[["CL_1"]],
    c(0.47747, 0.36249, 0.22133, 0.45891, 0.34166, 0.28111, 0.3571),
    tolerance = 1e-4)
  expect_equal(
    output_15603[["CL_2"]],
    c(0.21884, 0.27394, 0.33649, 0.31613, 0.36915, 0.42595, 0.22071),
    tolerance = 1e-4)
  expect_equal(
    output_15603[["CL_3"]],
    c(0.30368, 0.36356, 0.44218, 0.22496, 0.28919, 0.29294, 0.42219),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_15603),
    c("CL_1", "CL_2", "CL_3"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_15603),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_15603),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_15603),
    c(7L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_15603)),
    character(0),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: class_name = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19040 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = 1, add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'class_name': Must be of type 'string', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: class_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11387 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = NA, add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'class_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: class_name = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19888 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = NULL, add_predicted_classes = FALSE, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'class_name': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: add_predicted_classes...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19466 <- multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = TRUE, add_targets = FALSE)
  # Testing class
  expect_equal(
    class(output_19466),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19466[["class_1"]],
    c(0.47747, 0.36249, 0.22133, 0.45891, 0.34166, 0.28111, 0.3571),
    tolerance = 1e-4)
  expect_equal(
    output_19466[["class_2"]],
    c(0.21884, 0.27394, 0.33649, 0.31613, 0.36915, 0.42595, 0.22071),
    tolerance = 1e-4)
  expect_equal(
    output_19466[["class_3"]],
    c(0.30368, 0.36356, 0.44218, 0.22496, 0.28919, 0.29294, 0.42219),
    tolerance = 1e-4)
  expect_equal(
    output_19466[["Predicted Class"]],
    c("class_1", "class_3", "class_3", "class_1", "class_2", "class_2",
      "class_3"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19466),
    c("class_1", "class_2", "class_3", "Predicted Class"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19466),
    c("numeric", "numeric", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19466),
    c("double", "double", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19466),
    c(7L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19466)),
    character(0),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: add_predicted_classes...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10824 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = 1, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'add_predicted_classes': Must be of type 'logical flag', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: add_predicted_classes...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15142 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = NA, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'add_predicted_classes': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: add_predicted_classes...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13902 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = NULL, add_targets = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'add_predicted_classes': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: add_targets = TRUE
  xpectr::set_test_seed(42)
  # Assigning output
  output_19057 <- multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = TRUE)
  # Testing class
  expect_equal(
    class(output_19057),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19057[["class_1"]],
    c(0.47747, 0.36249, 0.22133, 0.45891, 0.34166, 0.28111, 0.3571),
    tolerance = 1e-4)
  expect_equal(
    output_19057[["class_2"]],
    c(0.21884, 0.27394, 0.33649, 0.31613, 0.36915, 0.42595, 0.22071),
    tolerance = 1e-4)
  expect_equal(
    output_19057[["class_3"]],
    c(0.30368, 0.36356, 0.44218, 0.22496, 0.28919, 0.29294, 0.42219),
    tolerance = 1e-4)
  expect_equal(
    output_19057[["Target"]],
    c("class_1", "class_3", "class_3", "class_1", "class_2", "class_2",
      "class_3"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19057),
    c("class_1", "class_2", "class_3", "Target"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19057),
    c("numeric", "numeric", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19057),
    c("double", "double", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19057),
    c(7L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19057)),
    character(0),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: add_targets = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14469 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = 1), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'add_targets': Must be of type 'logical flag', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: add_targets = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18360 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'add_targets': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing multiclass_probability_tibble(num_classes = ...
  # Changed from baseline: add_targets = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17375 <- xpectr::capture_side_effects(multiclass_probability_tibble(num_classes = 3, num_observations = 7, apply_softmax = TRUE, FUN = runif, class_name = "class_", add_predicted_classes = FALSE, add_targets = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'add_targets': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'multiclass_probability_tibble'                         ####
  #

})


