% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/awot_null.R
\name{awot_null}
\alias{awot_null}
\title{Prepare null model for awot.}
\usage{
awot_null(y, tr, x = NULL)
}
\arguments{
\item{y}{- Continuous response variable.}

\item{tr}{- Binary treatment variable, 1 for treated, 0 for placebo.}

\item{x}{- Covariates in addition to treatment variable.}
}
\value{
A list of objects needed for awot.
}
\description{
Prepare null model for awot.
}
\examples{
n = 100
y = rnorm(n)
x = data.frame(x1=rnorm(n))
tr = rbinom(n, 1, 0.5)
nullmod = awot_null(y, tr, x)
}
\references{
Hong Zhang, Devan Mehrotra and Judong Shen, "AWOT and CWOT for Genotype and Genotype by Treatment Interaction Joint Analysis in Pharmacogenetics GWAS".
}
