% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwot.R
\name{cwot}
\alias{cwot}
\title{Cauchy weighted joint test for main effect and genotype-by-treatment interaction effect for binary endpoints.}
\usage{
cwot(nullmod, g, weights = seq(-1, 1, 0.1))
}
\arguments{
\item{nullmod}{- The null model object from the output of cwot_null.}

\item{g}{- The variable of interest, e.g., the genotype.}

\item{weights}{- The pre-specified weights. The default choice is a vector of -1, -0.9,..., 0.9, 1.}
}
\value{
The p-values of CWOT, CWOT_Score, CWOT_LRT and the individual p-values of the composite genotypes.
}
\description{
Cauchy weighted joint test for main effect and genotype-by-treatment interaction effect for binary endpoints.
}
\examples{
n = 100
y = rbinom(n, 1, 0.3)
x = data.frame(x1=rnorm(n))
tr = rbinom(n, 1, 0.5)
g = rbinom(n, 2, 0.1)
nullmod = cwot_null(y, tr, x)
cwot(nullmod, g, weights=seq(-1,1,0.1))
}
\references{
Hong Zhang, Qing Li, Devan Mehrotra and Judong Shen. "CauchyCP: a powerful test under non-proportional hazards using Cauchy combination of change-point Cox regressions", arXiv:2101.00059.
}
