% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixedvonmises.R
\name{vonmisesmix}
\alias{vonmisesmix}
\alias{rvonmisesmix}
\alias{pvonmisesmix}
\alias{dvonmisesmix}
\alias{qvonmisesmix}
\title{Density, Distribution, Quantiles and Random Number Generation for the mixed von
Mises Distribution}
\usage{
rvonmisesmix(n, mu, kappa, prop)

dvonmisesmix(theta, mu, kappa, prop)

pvonmisesmix(theta, mu, kappa, prop)

qvonmisesmix(p, mu, kappa, prop)
}
\arguments{
\item{n}{\link[base]{integer} value, the number of random samples to be
generated with \code{rvonmisesmix()}.}

\item{mu}{\link[base]{numeric} \link[base]{vector} holding the mean directions.}

\item{kappa}{\link[base]{numeric} \link[base]{vector} holding the concentration
parameters.}

\item{prop}{\link[base]{numeric} \link[base]{vector}, holding the mixing proportions
of the components.}

\item{theta}{\link[base]{numeric} \link[base]{vector} giving the angles where
the density or distribution function is evaluated.}

\item{p}{\link[base]{numeric} \link[base]{vector} giving the probabilities where
the quantile function is evaluated.}
}
\value{
\itemize{
\item \code{dvonmisesmix()} gives a \link[base]{vector} of length \code{length(theta)}
 containing the density at \code{theta}.
\item \code{pvonmisesmix()} gives a
\link[base]{vector} of length \code{length(theta)} containing
the distribution function at the corresponding values of \code{theta}.
\item \code{qvonmisesmix()} gives a \link[base]{vector} of length \code{length(p)}
containing the quantiles at the corresponding values of \code{p}.
\item \code{rvonmisesmix()} generates a \link[base]{vector} of length \code{n}
containing the random samples, i.e. angles in \eqn{[-\pi, \pi)}.
}
}
\description{
The number of components in the mixed von Mises distribution is specified by the length
of the parameter vectors. The quantiles are numerically obtained from the distribution function using
monotone cubic splines.
}
\examples{

rvonmisesmix(10, mu = c(0, pi, pi/2), kappa = c(2, 2, 4), prop = c(0.6, 0.3, 0.1))

dvonmisesmix(c(0, 2, pi, 1), mu = c(0, pi), kappa = c(2, 2), prop = c(0.6, 0.4))

prob <- pvonmisesmix(c(0.1, pi), mu = c(0, pi, pi/2), kappa = c(2, 2, 4), prop = c(0.6, 0.3, 0.1))
prob
qvonmisesmix(prob, mu = c(0, pi, pi/2), kappa = c(2, 2, 4), prop = c(0.6, 0.3, 0.1))

}
