% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_fan.R
\name{do_fan}
\alias{do_fan}
\title{Compute summary statistics for \code{stat_fan}}
\usage{
do_fan(x, step = 0.01)
}
\arguments{
\item{x}{the value to summarize}

\item{step}{the number of bins to break the data into, based on the \code{quantile} function}
}
\value{
a data.frame containing
    \itemize{
        \item ymin    : the lower limit of the quantile
        \item ymax    : the upper limit of the quantile
        \item id      : an identifier for the quantile
        \item percent : the fill color to use in \code{geom_fan}
    }
}
\description{
Extracts the limits of the Ntiles of a distribution for use in the \code{stat_fan} function
}
\examples{
FanEuStockMarkets <- lapply(colnames(EuStockMarkets),function(id) {
    res <- do_fan(EuStockMarkets[,id])
    res$id <- id
    return(res)
})
FanEuStockMarkets <- do.call(rbind,FanEuStockMarkets)

}
