% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{internal_aggregate}
\alias{internal_aggregate}
\title{Aggregate Data Frame Columns by Group}
\usage{
internal_aggregate(data, group_cols)
}
\arguments{
\item{data}{A \link{data.frame} containing the data to be aggregated. It should
include both the grouping columns, an "ID" column, and the columns for which
aggregation shall take place.}

\item{group_cols}{A character vector specifying the names of the columns to
group by during aggregation.}
}
\value{
A \code{data.frame} containing the aggregated data.
}
\description{
internal function to aggregate columns of a data frame across "ID"
while considering a set of grouping columns. It retains the class and
attriubtes of the input data.
}
\details{
\code{internal_aggregate} identifies DV columns as those not in \code{group_cols} or
\code{"ID"}. It then calculates the mean of these DV columns, grouped by the
specified columns.
}
\seealso{
\code{\link[=aggregate_stats]{aggregate_stats()}}, \code{\link[=calc_stats]{calc_stats()}},
\code{\link[=new_stats_dm]{new_stats_dm()}}
}
\keyword{internal}
