% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_traces_dm.R
\name{summary.traces_dm}
\alias{summary.traces_dm}
\alias{print.summary.traces_dm}
\alias{summary.traces_dm_list}
\alias{print.summary.traces_dm_list}
\title{Summary for traces_dm and traces_dm_list Objects}
\usage{
\method{summary}{traces_dm}(object, ...)

\method{print}{summary.traces_dm}(x, ..., round_digits = drift_dm_default_rounding())

\method{summary}{traces_dm_list}(object, ...)

\method{print}{summary.traces_dm_list}(x, ..., round_digits = drift_dm_default_rounding())
}
\arguments{
\item{object}{an object of class \code{traces_dm} or \code{traces_dm_list}.}

\item{...}{additional arguments passed forward.}

\item{x}{an object of type \code{summary.traces_dm} or \code{summary.traces_dm_list}.}

\item{round_digits}{integer, specifying the number of decimal places for
rounding in the printed summary. Default is 3.}
}
\value{
\code{summary.traces_dm()} returns a list of class \code{summary.traces_dm} (see the
Details section summarizing each entry of this list).

\code{summary.traces_dm_list()} returns a list of class \code{summary.traces_dm_list}
(see the Details section summarizing each entry of this list).

\code{print.summary.traces_dm()} returns the \code{summary.traces_dm} object invisibly.

\code{print.summary.traces_dm_list()} returns the \code{summary.traces_dm_list} object
invisibly.
}
\description{
Summary and corresponding printing methods for \code{traces_dm} and
\code{traces_dm_list} objects, resulting from a call to
\code{\link[=simulate_traces]{simulate_traces()}}. Here, \code{traces_dm} objects are entries of the
returned list.
}
\details{
The \code{summary.traces_dm()} function constructs a summary list with
information about the \code{traces_dm} object, including:
\itemize{
\item \strong{k}: The number of traces in the object.
\item \strong{add_x}: A logical, indicating whether starting values were added.
\item \strong{orig_model_class}: The class label of the original model.
\item \strong{orig_prms}: The parameters with which the traces were simulated (for
the respective condition)
\item \strong{prms_solve}: The solver settings with which the traces were simulated.
\item \strong{fpt_desc}: A summary of the first passage times, including mean,
standard deviation, and response probabilities for upper and lower
boundaries.
}

The \code{summary.traces_dm_list()} function constructs a summary list with
information about the \code{traces_dm_list} object, including:
\itemize{
\item \strong{k}: A numeric vector, providing the number of traces per condition.
\item \strong{add_x}: A logical vector, indicating whether starting values were added
for each condition.
\item \strong{orig_prms}: A matrix, containing the original parameter values per
condition, with which the traces were simulated.
\item \strong{orig_model_class}: The class label of the original model
\item \strong{prms_solve}: A matrix of solver settings per condition.
\item \strong{fpt_desc}: A summary of the first passage times per condition, including
mean, standard deviation, and response probabilities for the upper or
lower boundary.
}

The \code{print.summary.traces_dm()} and  \code{print.summary.traces_dm_list()}
functions display the summary in a formatted way.
}
\examples{
# get a couple of traces a cross conditions
traces <- simulate_traces(dmc_dm(), k = c(5, 10))
summary(traces)

# get a single traces object
one_traces_obj <- traces[[1]]
summary(one_traces_obj)

}
