% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{cp.plt}
\alias{cp.plt}
\title{Plot data sequence, the first and second-order derivatives, and their local extrema}
\usage{
cp.plt(x, order, icd.noise, H)
}
\arguments{
\item{x}{numerical vector of signal or signal-plus-noise data}

\item{order}{order of derivative of data}

\item{icd.noise}{logical value indicating if \code{x} includes noise}

\item{H}{optional, vector of change-point locations}
}
\value{
a plot
}
\description{
Plot data sequence, the first and second-order derivatives, and their local extrema
}
\examples{
l = 1200
h = seq(150,by=150,length.out=6)
jump = c(0,1.5,2,2.2,1.8,2,1.5)*3
beta1 = c(2,-1,2.5,-3,-0.2,2.5,-0.5)/50
signal = gen.signal(l,h,jump,beta1)
noise = rnorm(length(signal),0,1)
gamma = 25
sdata = smth.gau(signal+noise,gamma)
dy = diff(sdata)
ddy = diff(sdata,differences=2)
cp.plt(signal,0,FALSE)
points(signal+noise,col="grey")
cp.plt(dy,1,H=h)
cp.plt(ddy,2,H=h)

}
