% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.R
\name{EquivalentModels}
\alias{EquivalentModels}
\alias{equivalenceClass}
\alias{equivalentDAGs}
\title{Generating Equivalent Models}
\usage{
equivalenceClass(x)

equivalentDAGs(x, n = 100)
}
\arguments{
\item{x}{the input graph, a DAG (or CPDAG for \code{equivalentDAGs}).}

\item{n}{maximal number of returned graphs.}
}
\description{
\code{equivalenceClass(x)} generates a complete partially directed acyclic graph 
(CPDAG) from an input DAG \code{x}. The CPDAG represents all graphs that are Markov 
equivalent to \code{x}: undirected
edges in the CPDAG can be oriented either way, as long as this does not create a cycle
or a new v-structure (a sugraph a -> m <- b, where a and b are not adjacent).
}
\details{
\code{equivalentDAGs(x,n)} enumerates at most \code{n} DAGs that are Markov equivalent
to the input DAG or CPDAG \code{x}.
}
\examples{
# How many equivalent DAGs are there for the sports DAG example?
g <- getExample("Shrier")
length(equivalentDAGs(g))
# Plot all equivalent DAGs
par( mfrow=c(2,3) )
lapply( equivalentDAGs(g), plot )
# How many edges can be reversed without changing the equivalence class?
sum(edges(equivalenceClass(g))$e == "--")
}
