% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoenc_conv_e.R
\name{autoenc_conv_e}
\alias{autoenc_conv_e}
\title{Convolutional Autoencoder - Encode}
\usage{
autoenc_conv_e(
  input_size,
  encoding_size,
  batch_size = 32,
  num_epochs = 1000,
  learning_rate = 0.001
)
}
\arguments{
\item{input_size}{input size}

\item{encoding_size}{encoding size}

\item{batch_size}{size for batch learning}

\item{num_epochs}{number of epochs for training}

\item{learning_rate}{learning rate}
}
\value{
A \code{autoenc_conv_e} object.
}
\description{
Creates a deep learning convolutional autoencoder (ConvAE) to encode sequences
of observations. Wraps a PyTorch implementation.
}
\examples{
\dontrun{
# Conv1D-based encoder expects data reshaped internally to (n, input_size, 1)
X <- matrix(rnorm(1000), nrow = 50, ncol = 20)
ae <- autoenc_conv_e(input_size = 20, encoding_size = 5, num_epochs = 50)
ae <- daltoolbox::fit(ae, X)
Z  <- daltoolbox::transform(ae, X)   # 50 x 5 encodings
}

# See:
# https://github.com/cefet-rj-dal/daltoolbox/blob/main/transf/autoenc_conv_e.md
}
\references{
Masci, J., Meier, U., Cireşan, D., & Schmidhuber, J. (2011). Stacked Convolutional Auto-Encoders.
}
