% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.rdepth.r
\name{gl.report.rdepth}
\alias{gl.report.rdepth}
\title{Reports summary of Read Depth for each locus}
\usage{
gl.report.rdepth(
  x,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.colors = NULL,
  plot.dir = NULL,
  plot.file = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP or presence/absence
(SilicoDArT) data [required].}

\item{plot.display}{Specify if plot is to be produced [default TRUE].}

\item{plot.theme}{User specified theme [default theme_dartR()].}

\item{plot.colors}{Vector with two color names for the borders and fill
[default c("#2171B5", "#6BAED6")].}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()]}

\item{plot.file}{Filename (minus extension) for the RDS plot file [Required for plot save]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
An unaltered genlight object
}
\description{
SNP datasets generated by DArT report AvgCountRef and AvgCountSnp as counts
of sequence tags for the reference and alternate alleles respectively.
These can be used to back calculate Read Depth. Fragment presence/absence
datasets as provided by DArT (SilicoDArT) provide Average Read Depth and
Standard Deviation of Read Depth as standard columns in their report. This
function reports the read depth by locus for each of several quantiles.
}
\details{
The function displays a table of minimum, maximum, mean and quantiles for
 read depth against possible thresholds that might subsequently be specified
 in \code{\link{gl.filter.rdepth}}. If plot.display=TRUE, display also includes a
  boxplot and a histogram to guide in the selection of a threshold for
  filtering on read depth.
 Plot colours can be set with gl.select.colors().
  If plot.file is specified, plots are saved to the directory specified by the user, or the global
  default working directory set by gl.set.wd() or to the tempdir().
 For examples of themes, see  \itemize{
 \item \url{https://ggplot2.tidyverse.org/reference/ggtheme.html} and \item
 \url{https://yutannihilation.github.io/allYourFigureAreBelongToUs/ggthemes/}
 }
}
\examples{
# SNP data
df <- gl.report.rdepth(testset.gl)
df <- gl.report.rdepth(testset.gs)

}
\seealso{
\code{\link{gl.filter.rdepth}}

Other matched report: 
\code{\link{gl.filter.excess.het}()},
\code{\link{gl.report.allna}()},
\code{\link{gl.report.callrate}()},
\code{\link{gl.report.hamming}()},
\code{\link{gl.report.locmetric}()},
\code{\link{gl.report.maf}()},
\code{\link{gl.report.overshoot}()},
\code{\link{gl.report.pa}()},
\code{\link{gl.report.reproducibility}()},
\code{\link{gl.report.secondaries}()},
\code{\link{gl.report.taglength}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{matched report}
