% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.read.dart.r
\name{gl.read.dart}
\alias{gl.read.dart}
\title{Imports DArT data into dartR and converts it into a dartR genlight object}
\usage{
gl.read.dart(
  filename,
  ind.metafile = NULL,
  recalc = TRUE,
  mono.rm = FALSE,
  nas = "-",
  topskip = NULL,
  lastmetric = NULL,
  covfilename = NULL,
  service.row = 1,
  plate.row = 3,
  probar = FALSE,
  verbose = NULL
)
}
\arguments{
\item{filename}{File containing the SNP data (csv file) [required].}

\item{ind.metafile}{File that contains additional information on individuals
[required].}

\item{recalc}{If TRUE, force the recalculation of locus metrics [default TRUE].}

\item{mono.rm}{If TRUE, force the removal of monomorphic loci (including all NAs.
[default FALSE].}

\item{nas}{A character specifying NAs [default '-'].}

\item{topskip}{A number specifying the number of initial rows to be skipped. [default NULL].}

\item{lastmetric}{Deprecated, specifies the last column of locus metadata. Can be 
specified as a column number [default NULL].}

\item{covfilename}{Deprecated, sse ind.metafile parameter [NULL].}

\item{service.row}{The row number for the DArT service
is contained [default 1].}

\item{plate.row}{The row number the plate well [default 3].}

\item{probar}{Show progress bar [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default 2, or as set by gl.set.verbose()].}
}
\value{
A dartR genlight object that contains individual and locus metrics
[if data were provided] and locus metrics [from a DArT report].
}
\description{
This function is a wrapper function that allows you to convert your DArT file
into a genlight object of class dartR.
}
\details{
The function will determine automatically if the data are in Diversity Arrays
one-row csv format or two-row csv format. 

The first 
row of data is determined from the number of rows with an * in the first 
column. This can be alternatively specified with the topskip parameter.

The DArT service code is added to the ind.metrics of the genlight object. 
The row containing the service code for each individual can be specified with 
the service.row parameter.

#'The DArT plate well is added to the ind.metrics of the genlight object. 
The row containing the plate well for each individual can be specified with 
the plate.row parameter.

If individuals have been deleted from the input file manually, then the locus
metrics supplied by DArT will no longer be correct and some loci may be
monomorphic. To accommodate this, set mono.rm and recalc to TRUE.
}
\examples{
dartfile <- system.file('extdata','testset_SNPs_2Row.csv', package='dartR')
metadata <- system.file('extdata','testset_metadata.csv', package='dartR')
gl <- gl.read.dart(dartfile, ind.metafile = metadata, probar=TRUE)


}
\seealso{
Other dartR-base: 
\code{\link{gl.drop.ind}()},
\code{\link{gl.drop.loc}()},
\code{\link{gl.drop.pop}()},
\code{\link{gl.edit.recode.ind}()},
\code{\link{gl.edit.recode.pop}()},
\code{\link{gl.keep.loc}()},
\code{\link{gl.make.recode.ind}()},
\code{\link{gl.recode.ind}()},
\code{\link{gl.recode.pop}()},
\code{\link{gl.set.verbosity}()}
}
\author{
Custodian: Bernd Gruber (Post to \url{https://groups.google.com/d/forum/dartr})
}
\concept{dartR-base}
