% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve.R
\name{dc_get_dcids_by_wikidata_id}
\alias{dc_get_dcids_by_wikidata_id}
\title{Resolve DCIDs from Wikidata IDs via Data Commons}
\usage{
dc_get_dcids_by_wikidata_id(
  wikidata_ids,
  api_key = Sys.getenv("DATACOMMONS_API_KEY"),
  base_url = Sys.getenv("DATACOMMONS_BASE_URL", unset =
    "https://api.datacommons.org/v2/"),
  return_type = "json"
)
}
\arguments{
\item{wikidata_ids}{The Wikidata IDs of the entities to look up.}

\item{api_key}{Your Data Commons API key. If not provided, uses the
environment variable \code{DATACOMMONS_API_KEY}.}

\item{base_url}{The base URL of the Data Commons API. Defaults to the public
endpoint. For custom deployments, must end with \verb{/core/api/v2/}.}

\item{return_type}{Return format: either \code{"list"} (parsed R object) or
\code{"json"} (JSON string).}
}
\value{
A list or JSON string, depending on \code{return_type}.
}
\description{
Resolves Wikidata identifiers (e.g., \code{"Q30"} for the United States) to
Data Commons DCIDs using the wikidataId property.
}
\examples{
\dontshow{if (dc_has_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get the DCID for the United States (Wikidata ID "Q30")
dc_get_dcids_by_wikidata_id("Q30")

# Batch query for multiple Wikidata IDs
dc_get_dcids_by_wikidata_id(c("Q30", "Q60"))
\dontshow{\}) # examplesIf}
}
