% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{dc_get_node}
\alias{dc_get_node}
\title{Retrieve Node Properties from Data Commons}
\usage{
dc_get_node(
  nodes,
  expression,
  api_key = Sys.getenv("DATACOMMONS_API_KEY"),
  base_url = Sys.getenv("DATACOMMONS_BASE_URL", unset =
    "https://api.datacommons.org/v2/"),
  return_type = "json"
)
}
\arguments{
\item{nodes}{A character vector of terms to resolve.}

\item{expression}{A relation expression string (e.g., \verb{<-*}, \verb{->name}, or
\verb{->[name, latitude]}).}

\item{api_key}{Your Data Commons API key. If not provided, uses the
environment variable \code{DATACOMMONS_API_KEY}.}

\item{base_url}{The base URL of the Data Commons API. Defaults to the public
endpoint. For custom deployments, must end with \verb{/core/api/v2/}.}

\item{return_type}{Return format: either \code{"list"} (parsed R object) or
\code{"json"} (JSON string).}
}
\value{
A list or JSON string, depending on \code{return_type}.
}
\description{
Queries the Data Commons API for specified property relationships of given
nodes.
}
\examples{
\dontshow{if (dc_has_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get all property labels for a given node
dc_get_node(nodes = "country/USA", expression = "<-")

# Get one property value for a given node
dc_get_node(nodes = "dc/03lw9rhpendw5", expression = "->name")

# Get multiple property values for multiple nodes
dc_get_node(
  nodes = c("geoId/06085", "geoId/06087"),
  expression = "->[name, latitude, longitude]"
)

# Get all property values for a node
dc_get_node(nodes = "PowerPlant", expression = "<-*")

# Get a list of all existing statistical variables
dc_get_node(nodes = "StatisticalVariable", expression = "<-typeOf")

# Get a list of all existing entity types
dc_get_node(nodes = "Class", expression = "<-typeOf")
\dontshow{\}) # examplesIf}
}
