% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KSWIN.R
\name{KSWIN}
\alias{KSWIN}
\title{KSWIN (Kolmogorov-Smirnov WINdowing) for Change Detection}
\description{
Implements the Kolmogorov-Smirnov test for detecting distribution changes within
a window of streaming data. KSWIN is a non-parametric method for change detection that compares
two samples to determine if they come from the same distribution.
}
\details{
KSWIN is effective for detecting changes in the underlying distribution of data streams.
It is particularly useful in scenarios where data properties may evolve over time, allowing for
early detection of changes that might affect subsequent data processing.
}
\examples{
set.seed(123)  # Setting a seed for reproducibility
data_part1 <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.7, 0.3))

# Introduce a change in data distribution
data_part2 <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.3, 0.7))

# Combine the two parts
data_stream <- c(data_part1, data_part2)
}
\references{
Christoph Raab, Moritz Heusinger, Frank-Michael Schleif, Reactive
Soft Prototype Computing for Concept Drift Streams, Neurocomputing, 2020.

Implementation: https://github.com/scikit-multiflow/scikit-multiflow/blob/a7e316d1cc79988a6df40da35312e00f6c4eabb2/src/skmultiflow/drift_detection/kswin.py
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{alpha}}{Significance level for the KS test.}

\item{\code{window_size}}{Total size of the data window used for testing.}

\item{\code{stat_size}}{Number of data points sampled from the window for the KS test.}

\item{\code{window}}{Current data window used for change detection.}

\item{\code{change_detected}}{Boolean flag indicating whether a change has been detected.}

\item{\code{p_value}}{P-value of the most recent KS test.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-KSWIN-new}{\code{KSWIN$new()}}
\item \href{#method-KSWIN-reset}{\code{KSWIN$reset()}}
\item \href{#method-KSWIN-add_element}{\code{KSWIN$add_element()}}
\item \href{#method-KSWIN-detected_change}{\code{KSWIN$detected_change()}}
\item \href{#method-KSWIN-clone}{\code{KSWIN$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KSWIN-new"></a>}}
\if{latex}{\out{\hypertarget{method-KSWIN-new}{}}}
\subsection{Method \code{new()}}{
Initializes the KSWIN detector with specific settings.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KSWIN$new(alpha = 0.005, window_size = 100, stat_size = 30, data = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{The significance level for the KS test.}

\item{\code{window_size}}{The size of the data window for change detection.}

\item{\code{stat_size}}{The number of samples in the statistical test window.}

\item{\code{data}}{Initial data to populate the window, if provided.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KSWIN-reset"></a>}}
\if{latex}{\out{\hypertarget{method-KSWIN-reset}{}}}
\subsection{Method \code{reset()}}{
Resets the internal state of the detector to its initial conditions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KSWIN$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KSWIN-add_element"></a>}}
\if{latex}{\out{\hypertarget{method-KSWIN-add_element}{}}}
\subsection{Method \code{add_element()}}{
Adds a new element to the data window and updates the detection status based on the KS test.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KSWIN$add_element(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The new data value to add to the window.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KSWIN-detected_change"></a>}}
\if{latex}{\out{\hypertarget{method-KSWIN-detected_change}{}}}
\subsection{Method \code{detected_change()}}{
Checks if a change has been detected based on the most recent KS test.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KSWIN$detected_change()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Boolean indicating whether a change was detected.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KSWIN-clone"></a>}}
\if{latex}{\out{\hypertarget{method-KSWIN-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KSWIN$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
